# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import DnsManagementClientConfiguration
from .operations import RecordSetsOperations
from .operations import ZonesOperations
from .operations import DnsResourceReferenceOperations
from . import models


class DnsManagementClient(SDKClient):
    """The DNS Management Client.

    :ivar config: Configuration for client.
    :vartype config: DnsManagementClientConfiguration

    :ivar record_sets: RecordSets operations
    :vartype record_sets: azure.mgmt.dns.v2018_05_01.operations.RecordSetsOperations
    :ivar zones: Zones operations
    :vartype zones: azure.mgmt.dns.v2018_05_01.operations.ZonesOperations
    :ivar dns_resource_reference: DnsResourceReference operations
    :vartype dns_resource_reference: azure.mgmt.dns.v2018_05_01.operations.DnsResourceReferenceOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Specifies the Azure subscription ID, which
     uniquely identifies the Microsoft Azure subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = DnsManagementClientConfiguration(credentials, subscription_id, base_url)
        super(DnsManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-05-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.record_sets = RecordSetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.zones = ZonesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.dns_resource_reference = DnsResourceReferenceOperations(
            self._client, self.config, self._serialize, self._deserialize)
