# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

import msrest.serialization

from ._container_service_client_enums import *


class SubResource(msrest.serialization.Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param type_properties_type: AgentPoolType represents types of an agent pool. Possible values
     include: "VirtualMachineScaleSets", "AvailabilitySet".
    :type type_properties_type: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :type orchestrator_version: str
    :param node_image_version: Version of node image.
    :type node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes.
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Possible values include: "Spot", "Regular". Default value:
     "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :type spot_max_price: float
    :param tags: A set of tags. Agent pool tags to be persisted on the agent pool virtual machine
     scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :type node_taints: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'os_disk_size_gb': {'maximum': 1023, 'minimum': 0},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'properties.osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'properties.vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'properties.maxPods', 'type': 'int'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'max_count': {'key': 'properties.maxCount', 'type': 'int'},
        'min_count': {'key': 'properties.minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'properties.enableAutoScaling', 'type': 'bool'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'orchestrator_version': {'key': 'properties.orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'properties.nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'properties.upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'properties.availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'properties.enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'properties.scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'properties.scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'properties.spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'properties.tags', 'type': '{str}'},
        'node_labels': {'key': 'properties.nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'properties.nodeTaints', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type_properties_type: Optional[Union[str, "AgentPoolType"]] = None,
        mode: Optional[Union[str, "AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        node_image_version: Optional[str] = None,
        upgrade_settings: Optional["AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Optional[Union[str, "ScaleSetPriority"]] = "Regular",
        scale_set_eviction_policy: Optional[Union[str, "ScaleSetEvictionPolicy"]] = "Delete",
        spot_max_price: Optional[float] = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        **kwargs
    ):
        super(AgentPool, self).__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type_properties_type = type_properties_type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = node_image_version
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints


class AgentPoolAvailableVersions(msrest.serialization.Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the agent pool available versions.
    :vartype id: str
    :ivar name: Name of the agent pool available versions.
    :vartype name: str
    :ivar type: Type of the agent pool  available versions.
    :vartype type: str
    :param agent_pool_versions: List of versions available for agent pool.
    :type agent_pool_versions:
     list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'agent_pool_versions': {'key': 'properties.agentPoolVersions', 'type': '[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]'},
    }

    def __init__(
        self,
        *,
        agent_pool_versions: Optional[List["AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem"]] = None,
        **kwargs
    ):
        super(AgentPoolAvailableVersions, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = agent_pool_versions


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(msrest.serialization.Model):
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :param default: Whether this version is the default agent pool version.
    :type default: bool
    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'bool'},
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        super(AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem, self).__init__(**kwargs)
        self.default = default
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolListResult(msrest.serialization.Model):
    """The response from the List Agent Pools operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of agent pools.
    :type value: list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPool]
    :ivar next_link: The URL to get the next set of agent pool results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AgentPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AgentPool"]] = None,
        **kwargs
    ):
        super(AgentPoolListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AgentPoolUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: Name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: Type of the agent pool upgrade profile.
    :vartype type: str
    :param kubernetes_version: Required. Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param os_type: Required. OsType to be used to specify os type. Choose from Linux and Windows.
     Default to Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    :param latest_node_image_version: LatestNodeImageVersion is the latest AKS supported node image
     version.
    :type latest_node_image_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'upgrades': {'key': 'properties.upgrades', 'type': '[AgentPoolUpgradeProfilePropertiesUpgradesItem]'},
        'latest_node_image_version': {'key': 'properties.latestNodeImageVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "OSType"] = "Linux",
        upgrades: Optional[List["AgentPoolUpgradeProfilePropertiesUpgradesItem"]] = None,
        latest_node_image_version: Optional[str] = None,
        **kwargs
    ):
        super(AgentPoolUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kubernetes_version
        self.os_type = os_type
        self.upgrades = upgrades
        self.latest_node_image_version = latest_node_image_version


class AgentPoolUpgradeProfilePropertiesUpgradesItem(msrest.serialization.Model):
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        super(AgentPoolUpgradeProfilePropertiesUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolUpgradeSettings(msrest.serialization.Model):
    """Settings for upgrading an agentpool.

    :param max_surge: Count or percentage of additional nodes to be added during upgrade. If empty
     uses AKS default.
    :type max_surge: str
    """

    _attribute_map = {
        'max_surge': {'key': 'maxSurge', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        max_surge: Optional[str] = None,
        **kwargs
    ):
        super(AgentPoolUpgradeSettings, self).__init__(**kwargs)
        self.max_surge = max_surge


class BaseManagedCluster(msrest.serialization.Model):
    """BaseManagedCluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param identity: The identity of the managed cluster, if configured.
    :type identity: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :type kubernetes_version: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: Profile for Linux VMs in the container service cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceLinuxProfile
    :param windows_profile: Profile for Windows VMs in the container service cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal identity for the
     cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: Profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfile]
    :param node_resource_group: Name of the resource group containing agent pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :type enable_pod_security_policy: bool
    :param network_profile: Profile of network configuration.
    :type network_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceNetworkProfile
    :param aad_profile: Profile of Azure Active Directory configuration.
    :type aad_profile: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAADProfile
    :param auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :type auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesAutoScalerProfile
    :param api_server_access_profile: Access profile for managed cluster API server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAPIServerAccessProfile
    :param disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :type disk_encryption_set_id: str
    :param identity_profile: Identities associated with the cluster.
    :type identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesIdentityProfileValue]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
        'private_fqdn': {'readonly': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'private_fqdn': {'key': 'properties.privateFQDN', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'auto_scaler_profile': {'key': 'properties.autoScalerProfile', 'type': 'ManagedClusterPropertiesAutoScalerProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'disk_encryption_set_id': {'key': 'properties.diskEncryptionSetID', 'type': 'str'},
        'identity_profile': {'key': 'properties.identityProfile', 'type': '{ManagedClusterPropertiesIdentityProfileValue}'},
    }

    def __init__(
        self,
        *,
        identity: Optional["ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        agent_pool_profiles: Optional[List["ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "ManagedClusterAddonProfile"]] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["ManagedClusterAADProfile"] = None,
        auto_scaler_profile: Optional["ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[Dict[str, "ManagedClusterPropertiesIdentityProfileValue"]] = None,
        **kwargs
    ):
        super(BaseManagedCluster, self).__init__(**kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Container service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.containerservice.v2020_04_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ContainerServiceDiagnosticsProfile(msrest.serialization.Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param vm_diagnostics: Required. Profile for diagnostics on the container service VMs.
    :type vm_diagnostics:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        'vm_diagnostics': {'required': True},
    }

    _attribute_map = {
        'vm_diagnostics': {'key': 'vmDiagnostics', 'type': 'ContainerServiceVMDiagnostics'},
    }

    def __init__(
        self,
        *,
        vm_diagnostics: "ContainerServiceVMDiagnostics",
        **kwargs
    ):
        super(ContainerServiceDiagnosticsProfile, self).__init__(**kwargs)
        self.vm_diagnostics = vm_diagnostics


class ContainerServiceLinuxProfile(msrest.serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. The administrator username to use for Linux VMs.
    :type admin_username: str
    :param ssh: Required. SSH configuration for Linux-based VMs running on Azure.
    :type ssh: ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[A-Za-z][-A-Za-z0-9_]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        ssh: "ContainerServiceSshConfiguration",
        **kwargs
    ):
        super(ContainerServiceLinuxProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceMasterProfile(msrest.serialization.Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of masters (VMs) in the container service cluster. Allowed values are 1,
     3, and 5. The default value is 1. Possible values include: 1, 3, 5. Default value: "1".
    :type count: str or ~azure.mgmt.containerservice.v2020_04_01.models.Count
    :param dns_prefix: Required. DNS prefix to be used to create the FQDN for the master pool.
    :type dns_prefix: str
    :param vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
     "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
     "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
     "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
     "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
     "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :type vnet_subnet_id: str
    :param first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static
     ip of masters.
    :type first_consecutive_static_ip: str
    :param storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
    :type storage_profile: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        'dns_prefix': {'required': True},
        'vm_size': {'required': True},
        'os_disk_size_gb': {'maximum': 1023, 'minimum': 0},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'first_consecutive_static_ip': {'key': 'firstConsecutiveStaticIP', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dns_prefix: str,
        vm_size: Union[str, "ContainerServiceVMSizeTypes"],
        count: Optional[Union[int, "Count"]] = "1",
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        first_consecutive_static_ip: Optional[str] = "10.240.255.5",
        storage_profile: Optional[Union[str, "ContainerServiceStorageProfileTypes"]] = None,
        **kwargs
    ):
        super(ContainerServiceMasterProfile, self).__init__(**kwargs)
        self.count = count
        self.dns_prefix = dns_prefix
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.first_consecutive_static_ip = first_consecutive_static_ip
        self.storage_profile = storage_profile
        self.fqdn = None


class ContainerServiceNetworkProfile(msrest.serialization.Model):
    """Profile of network configuration.

    :param network_plugin: Network plugin used for building Kubernetes network. Possible values
     include: "azure", "kubenet". Default value: "kubenet".
    :type network_plugin: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkPlugin
    :param network_policy: Network policy used for building Kubernetes network. Possible values
     include: "calico", "azure".
    :type network_policy: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkPolicy
    :param network_mode: Network mode used for building Kubernetes network. Possible values
     include: "transparent", "bridge".
    :type network_mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkMode
    :param pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    :type pod_cidr: str
    :param service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :type docker_bridge_cidr: str
    :param outbound_type: The outbound (egress) routing method. Possible values include:
     "loadBalancer", "userDefinedRouting". Default value: "loadBalancer".
    :type outbound_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OutboundType
    :param load_balancer_sku: The load balancer sku for the managed cluster. Possible values
     include: "standard", "basic".
    :type load_balancer_sku: str or ~azure.mgmt.containerservice.v2020_04_01.models.LoadBalancerSku
    :param load_balancer_profile: Profile of the cluster load balancer.
    :type load_balancer_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfile
    """

    _validation = {
        'pod_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'network_plugin': {'key': 'networkPlugin', 'type': 'str'},
        'network_policy': {'key': 'networkPolicy', 'type': 'str'},
        'network_mode': {'key': 'networkMode', 'type': 'str'},
        'pod_cidr': {'key': 'podCidr', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
        'outbound_type': {'key': 'outboundType', 'type': 'str'},
        'load_balancer_sku': {'key': 'loadBalancerSku', 'type': 'str'},
        'load_balancer_profile': {'key': 'loadBalancerProfile', 'type': 'ManagedClusterLoadBalancerProfile'},
    }

    def __init__(
        self,
        *,
        network_plugin: Optional[Union[str, "NetworkPlugin"]] = "kubenet",
        network_policy: Optional[Union[str, "NetworkPolicy"]] = None,
        network_mode: Optional[Union[str, "NetworkMode"]] = None,
        pod_cidr: Optional[str] = "10.244.0.0/16",
        service_cidr: Optional[str] = "10.0.0.0/16",
        dns_service_ip: Optional[str] = "10.0.0.10",
        docker_bridge_cidr: Optional[str] = "172.17.0.1/16",
        outbound_type: Optional[Union[str, "OutboundType"]] = "loadBalancer",
        load_balancer_sku: Optional[Union[str, "LoadBalancerSku"]] = None,
        load_balancer_profile: Optional["ManagedClusterLoadBalancerProfile"] = None,
        **kwargs
    ):
        super(ContainerServiceNetworkProfile, self).__init__(**kwargs)
        self.network_plugin = network_plugin
        self.network_policy = network_policy
        self.network_mode = network_mode
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr
        self.outbound_type = outbound_type
        self.load_balancer_sku = load_balancer_sku
        self.load_balancer_profile = load_balancer_profile


class ContainerServiceSshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to Azure.

    :param public_keys: Required. The list of SSH public keys used to authenticate with Linux-based
     VMs. Only expect one key specified.
    :type public_keys:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        'public_keys': {'required': True},
    }

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[ContainerServiceSshPublicKey]'},
    }

    def __init__(
        self,
        *,
        public_keys: List["ContainerServiceSshPublicKey"],
        **kwargs
    ):
        super(ContainerServiceSshConfiguration, self).__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to Azure.

    :param key_data: Required. Certificate public key used to authenticate with VMs through SSH.
     The certificate must be in PEM format with or without headers.
    :type key_data: str
    """

    _validation = {
        'key_data': {'required': True},
    }

    _attribute_map = {
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_data: str,
        **kwargs
    ):
        super(ContainerServiceSshPublicKey, self).__init__(**kwargs)
        self.key_data = key_data


class ContainerServiceVMDiagnostics(msrest.serialization.Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the VM diagnostic agent is provisioned on the VM.
    :type enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are stored.
    :vartype storage_uri: str
    """

    _validation = {
        'enabled': {'required': True},
        'storage_uri': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        **kwargs
    ):
        super(ContainerServiceVMDiagnostics, self).__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = None


class CredentialResult(msrest.serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytearray
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResult, self).__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(msrest.serialization.Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.containerservice.v2020_04_01.models.CredentialResult]
    """

    _validation = {
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[CredentialResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialResults, self).__init__(**kwargs)
        self.kubeconfigs = None


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedCluster(Resource, BaseManagedCluster):
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param identity: The identity of the managed cluster, if configured.
    :type identity: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :param kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :type kubernetes_version: str
    :param dns_prefix: DNS prefix specified when creating the managed cluster.
    :type dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :param agent_pool_profiles: Properties of the agent pool.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAgentPoolProfile]
    :param linux_profile: Profile for Linux VMs in the container service cluster.
    :type linux_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceLinuxProfile
    :param windows_profile: Profile for Windows VMs in the container service cluster.
    :type windows_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterWindowsProfile
    :param service_principal_profile: Information about a service principal identity for the
     cluster to use for manipulating Azure APIs.
    :type service_principal_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterServicePrincipalProfile
    :param addon_profiles: Profile of managed cluster add-on.
    :type addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfile]
    :param node_resource_group: Name of the resource group containing agent pool nodes.
    :type node_resource_group: str
    :param enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :type enable_rbac: bool
    :param enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :type enable_pod_security_policy: bool
    :param network_profile: Profile of network configuration.
    :type network_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceNetworkProfile
    :param aad_profile: Profile of Azure Active Directory configuration.
    :type aad_profile: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAADProfile
    :param auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :type auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesAutoScalerProfile
    :param api_server_access_profile: Access profile for managed cluster API server.
    :type api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAPIServerAccessProfile
    :param disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :type disk_encryption_set_id: str
    :param identity_profile: Identities associated with the cluster.
    :type identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesIdentityProfileValue]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The managed cluster SKU.
    :type sku: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKU
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'max_agent_pools': {'readonly': True},
        'fqdn': {'readonly': True},
        'private_fqdn': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ManagedClusterIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'max_agent_pools': {'key': 'properties.maxAgentPools', 'type': 'int'},
        'kubernetes_version': {'key': 'properties.kubernetesVersion', 'type': 'str'},
        'dns_prefix': {'key': 'properties.dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'private_fqdn': {'key': 'properties.privateFQDN', 'type': 'str'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterAgentPoolProfile]'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ManagedClusterWindowsProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ManagedClusterServicePrincipalProfile'},
        'addon_profiles': {'key': 'properties.addonProfiles', 'type': '{ManagedClusterAddonProfile}'},
        'node_resource_group': {'key': 'properties.nodeResourceGroup', 'type': 'str'},
        'enable_rbac': {'key': 'properties.enableRBAC', 'type': 'bool'},
        'enable_pod_security_policy': {'key': 'properties.enablePodSecurityPolicy', 'type': 'bool'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerServiceNetworkProfile'},
        'aad_profile': {'key': 'properties.aadProfile', 'type': 'ManagedClusterAADProfile'},
        'auto_scaler_profile': {'key': 'properties.autoScalerProfile', 'type': 'ManagedClusterPropertiesAutoScalerProfile'},
        'api_server_access_profile': {'key': 'properties.apiServerAccessProfile', 'type': 'ManagedClusterAPIServerAccessProfile'},
        'disk_encryption_set_id': {'key': 'properties.diskEncryptionSetID', 'type': 'str'},
        'identity_profile': {'key': 'properties.identityProfile', 'type': '{ManagedClusterPropertiesIdentityProfileValue}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ManagedClusterSKU'},
    }

    def __init__(
        self,
        *,
        location: str,
        identity: Optional["ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        agent_pool_profiles: Optional[List["ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "ManagedClusterAddonProfile"]] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["ManagedClusterAADProfile"] = None,
        auto_scaler_profile: Optional["ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[Dict[str, "ManagedClusterPropertiesIdentityProfileValue"]] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["ManagedClusterSKU"] = None,
        **kwargs
    ):
        super(ManagedCluster, self).__init__(location=location, tags=tags, identity=identity, kubernetes_version=kubernetes_version, dns_prefix=dns_prefix, agent_pool_profiles=agent_pool_profiles, linux_profile=linux_profile, windows_profile=windows_profile, service_principal_profile=service_principal_profile, addon_profiles=addon_profiles, node_resource_group=node_resource_group, enable_rbac=enable_rbac, enable_pod_security_policy=enable_pod_security_policy, network_profile=network_profile, aad_profile=aad_profile, auto_scaler_profile=auto_scaler_profile, api_server_access_profile=api_server_access_profile, disk_encryption_set_id=disk_encryption_set_id, identity_profile=identity_profile, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.sku = sku


class ManagedClusterAADProfile(msrest.serialization.Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    :param managed: Whether to enable managed AAD.
    :type managed: bool
    :param admin_group_object_i_ds: AAD group object IDs that will have admin role of the cluster.
    :type admin_group_object_i_ds: list[str]
    :param client_app_id: The client AAD application ID.
    :type client_app_id: str
    :param server_app_id: The server AAD application ID.
    :type server_app_id: str
    :param server_app_secret: The server AAD application secret.
    :type server_app_secret: str
    :param tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :type tenant_id: str
    """

    _attribute_map = {
        'managed': {'key': 'managed', 'type': 'bool'},
        'admin_group_object_i_ds': {'key': 'adminGroupObjectIDs', 'type': '[str]'},
        'client_app_id': {'key': 'clientAppID', 'type': 'str'},
        'server_app_id': {'key': 'serverAppID', 'type': 'str'},
        'server_app_secret': {'key': 'serverAppSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        managed: Optional[bool] = None,
        admin_group_object_i_ds: Optional[List[str]] = None,
        client_app_id: Optional[str] = None,
        server_app_id: Optional[str] = None,
        server_app_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterAADProfile, self).__init__(**kwargs)
        self.managed = managed
        self.admin_group_object_i_ds = admin_group_object_i_ds
        self.client_app_id = client_app_id
        self.server_app_id = server_app_id
        self.server_app_secret = server_app_secret
        self.tenant_id = tenant_id


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kube_config: Base64-encoded Kubernetes configuration file.
    :type kube_config: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kube_config': {'key': 'properties.kubeConfig', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kube_config: Optional[bytearray] = None,
        **kwargs
    ):
        super(ManagedClusterAccessProfile, self).__init__(location=location, tags=tags, **kwargs)
        self.kube_config = kube_config


class ManagedClusterAddonProfile(msrest.serialization.Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the add-on is enabled or not.
    :type enabled: bool
    :param config: Key-value pairs for configuring an add-on.
    :type config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        'enabled': {'required': True},
        'identity': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'config': {'key': 'config', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedClusterAddonProfileIdentity'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        config: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ManagedClusterAddonProfile, self).__init__(**kwargs)
        self.enabled = enabled
        self.config = config
        self.identity = None


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs
    ):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id = client_id
        self.object_id = object_id


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterAddonProfileIdentity, self).__init__(resource_id=resource_id, client_id=client_id, object_id=object_id, **kwargs)


class ManagedClusterAgentPoolProfileProperties(msrest.serialization.Model):
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible values include:
     "VirtualMachineScaleSets", "AvailabilitySet".
    :type type: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :type orchestrator_version: str
    :param node_image_version: Version of node image.
    :type node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes.
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Possible values include: "Spot", "Regular". Default value:
     "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :type spot_max_price: float
    :param tags: A set of tags. Agent pool tags to be persisted on the agent pool virtual machine
     scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :type node_taints: list[str]
    """

    _validation = {
        'os_disk_size_gb': {'maximum': 1023, 'minimum': 0},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type: Optional[Union[str, "AgentPoolType"]] = None,
        mode: Optional[Union[str, "AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        node_image_version: Optional[str] = None,
        upgrade_settings: Optional["AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Optional[Union[str, "ScaleSetPriority"]] = "Regular",
        scale_set_eviction_policy: Optional[Union[str, "ScaleSetEvictionPolicy"]] = "Delete",
        spot_max_price: Optional[float] = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        **kwargs
    ):
        super(ManagedClusterAgentPoolProfileProperties, self).__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type = type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = node_image_version
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints


class ManagedClusterAgentPoolProfile(ManagedClusterAgentPoolProfileProperties):
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :type count: int
    :param vm_size: Size of agent VMs. Possible values include: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :param os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
     machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
     according to the vmSize specified.
    :type os_disk_size_gb: int
    :param vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :type vnet_subnet_id: str
    :param max_pods: Maximum number of pods that can run on a node.
    :type max_pods: int
    :param os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :param max_count: Maximum number of nodes for auto-scaling.
    :type max_count: int
    :param min_count: Minimum number of nodes for auto-scaling.
    :type min_count: int
    :param enable_auto_scaling: Whether to enable auto-scaler.
    :type enable_auto_scaling: bool
    :param type: AgentPoolType represents types of an agent pool. Possible values include:
     "VirtualMachineScaleSets", "AvailabilitySet".
    :type type: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
    :param mode: AgentPoolMode represents mode of an agent pool. Possible values include: "System",
     "User".
    :type mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
    :param orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :type orchestrator_version: str
    :param node_image_version: Version of node image.
    :type node_image_version: str
    :param upgrade_settings: Settings for upgrading the agentpool.
    :type upgrade_settings:
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :type availability_zones: list[str]
    :param enable_node_public_ip: Enable public IP for nodes.
    :type enable_node_public_ip: bool
    :param scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Possible values include: "Spot", "Regular". Default value:
     "Regular".
    :type scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
    :param scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Possible values include: "Delete",
     "Deallocate". Default value: "Delete".
    :type scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
    :param spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :type spot_max_price: float
    :param tags: A set of tags. Agent pool tags to be persisted on the agent pool virtual machine
     scale set.
    :type tags: dict[str, str]
    :param node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :type node_labels: dict[str, str]
    :param node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :type node_taints: list[str]
    :param name: Required. Unique name of the agent pool profile in the context of the subscription
     and resource group.
    :type name: str
    """

    _validation = {
        'os_disk_size_gb': {'maximum': 1023, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'name': {'required': True, 'pattern': r'^[a-z][a-z0-9]{0,11}$'},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'max_pods': {'key': 'maxPods', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'enable_auto_scaling': {'key': 'enableAutoScaling', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'node_image_version': {'key': 'nodeImageVersion', 'type': 'str'},
        'upgrade_settings': {'key': 'upgradeSettings', 'type': 'AgentPoolUpgradeSettings'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'availability_zones': {'key': 'availabilityZones', 'type': '[str]'},
        'enable_node_public_ip': {'key': 'enableNodePublicIP', 'type': 'bool'},
        'scale_set_priority': {'key': 'scaleSetPriority', 'type': 'str'},
        'scale_set_eviction_policy': {'key': 'scaleSetEvictionPolicy', 'type': 'str'},
        'spot_max_price': {'key': 'spotMaxPrice', 'type': 'float'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'node_labels': {'key': 'nodeLabels', 'type': '{str}'},
        'node_taints': {'key': 'nodeTaints', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type: Optional[Union[str, "AgentPoolType"]] = None,
        mode: Optional[Union[str, "AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        node_image_version: Optional[str] = None,
        upgrade_settings: Optional["AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Optional[Union[str, "ScaleSetPriority"]] = "Regular",
        scale_set_eviction_policy: Optional[Union[str, "ScaleSetEvictionPolicy"]] = "Delete",
        spot_max_price: Optional[float] = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        **kwargs
    ):
        super(ManagedClusterAgentPoolProfile, self).__init__(count=count, vm_size=vm_size, os_disk_size_gb=os_disk_size_gb, vnet_subnet_id=vnet_subnet_id, max_pods=max_pods, os_type=os_type, max_count=max_count, min_count=min_count, enable_auto_scaling=enable_auto_scaling, type=type, mode=mode, orchestrator_version=orchestrator_version, node_image_version=node_image_version, upgrade_settings=upgrade_settings, availability_zones=availability_zones, enable_node_public_ip=enable_node_public_ip, scale_set_priority=scale_set_priority, scale_set_eviction_policy=scale_set_eviction_policy, spot_max_price=spot_max_price, tags=tags, node_labels=node_labels, node_taints=node_taints, **kwargs)
        self.name = name


class ManagedClusterAPIServerAccessProfile(msrest.serialization.Model):
    """Access profile for managed cluster API server.

    :param authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
    :type authorized_ip_ranges: list[str]
    :param enable_private_cluster: Whether to create the cluster as a private cluster or not.
    :type enable_private_cluster: bool
    """

    _attribute_map = {
        'authorized_ip_ranges': {'key': 'authorizedIPRanges', 'type': '[str]'},
        'enable_private_cluster': {'key': 'enablePrivateCluster', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        authorized_ip_ranges: Optional[List[str]] = None,
        enable_private_cluster: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedClusterAPIServerAccessProfile, self).__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges
        self.enable_private_cluster = enable_private_cluster


class ManagedClusterIdentity(msrest.serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by master
     components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by master
     components.
    :vartype tenant_id: str
    :param type: The type of identity used for the managed cluster. Type 'SystemAssigned' will use
     an implicitly created identity in master components and an auto-created user assigned identity
     in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster,
     service principal will be used instead. Possible values include: "SystemAssigned", "None".
    :type type: str or ~azure.mgmt.containerservice.v2020_04_01.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        **kwargs
    ):
        super(ManagedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ManagedClusterListResult(msrest.serialization.Model):
    """The response from the List Managed Clusters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of managed clusters.
    :type value: list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedCluster]
    :ivar next_link: The URL to get the next set of managed cluster results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedCluster"]] = None,
        **kwargs
    ):
        super(ManagedClusterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ManagedClusterLoadBalancerProfile(msrest.serialization.Model):
    """Profile of the managed cluster load balancer.

    :param managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
    :type managed_outbound_i_ps:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :param outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load
     balancer.
    :type outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :param outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
    :type outbound_i_ps:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :param effective_outbound_i_ps: The effective outbound IP resources of the cluster load
     balancer.
    :type effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
    :param allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed values
     must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure
     dynamically allocating ports.
    :type allocated_outbound_ports: int
    :param idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
    :type idle_timeout_in_minutes: int
    """

    _validation = {
        'allocated_outbound_ports': {'maximum': 64000, 'minimum': 0},
        'idle_timeout_in_minutes': {'maximum': 120, 'minimum': 4},
    }

    _attribute_map = {
        'managed_outbound_i_ps': {'key': 'managedOutboundIPs', 'type': 'ManagedClusterLoadBalancerProfileManagedOutboundIPs'},
        'outbound_ip_prefixes': {'key': 'outboundIPPrefixes', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPPrefixes'},
        'outbound_i_ps': {'key': 'outboundIPs', 'type': 'ManagedClusterLoadBalancerProfileOutboundIPs'},
        'effective_outbound_i_ps': {'key': 'effectiveOutboundIPs', 'type': '[ResourceReference]'},
        'allocated_outbound_ports': {'key': 'allocatedOutboundPorts', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'idleTimeoutInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        managed_outbound_i_ps: Optional["ManagedClusterLoadBalancerProfileManagedOutboundIPs"] = None,
        outbound_ip_prefixes: Optional["ManagedClusterLoadBalancerProfileOutboundIPPrefixes"] = None,
        outbound_i_ps: Optional["ManagedClusterLoadBalancerProfileOutboundIPs"] = None,
        effective_outbound_i_ps: Optional[List["ResourceReference"]] = None,
        allocated_outbound_ports: Optional[int] = 0,
        idle_timeout_in_minutes: Optional[int] = 30,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfile, self).__init__(**kwargs)
        self.managed_outbound_i_ps = managed_outbound_i_ps
        self.outbound_ip_prefixes = outbound_ip_prefixes
        self.outbound_i_ps = outbound_i_ps
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.allocated_outbound_ports = allocated_outbound_ports
        self.idle_timeout_in_minutes = idle_timeout_in_minutes


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(msrest.serialization.Model):
    """Desired managed outbound IPs for the cluster load balancer.

    :param count: Desired number of outbound IP created/managed by Azure for the cluster load
     balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
    :type count: int
    """

    _validation = {
        'count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = 1,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileManagedOutboundIPs, self).__init__(**kwargs)
        self.count = count


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(msrest.serialization.Model):
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :param public_ip_prefixes: A list of public IP prefix resources.
    :type public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_ip_prefixes': {'key': 'publicIPPrefixes', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        *,
        public_ip_prefixes: Optional[List["ResourceReference"]] = None,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileOutboundIPPrefixes, self).__init__(**kwargs)
        self.public_ip_prefixes = public_ip_prefixes


class ManagedClusterLoadBalancerProfileOutboundIPs(msrest.serialization.Model):
    """Desired outbound IP resources for the cluster load balancer.

    :param public_i_ps: A list of public IP resources.
    :type public_i_ps: list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
    """

    _attribute_map = {
        'public_i_ps': {'key': 'publicIPs', 'type': '[ResourceReference]'},
    }

    def __init__(
        self,
        *,
        public_i_ps: Optional[List["ResourceReference"]] = None,
        **kwargs
    ):
        super(ManagedClusterLoadBalancerProfileOutboundIPs, self).__init__(**kwargs)
        self.public_i_ps = public_i_ps


class ManagedClusterPoolUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to Azure.

    :param kubernetes_version: Required. Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param name: Pool name.
    :type name: str
    :param os_type: Required. OsType to be used to specify os type. Choose from Linux and Windows.
     Default to Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :type os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :param upgrades: List of orchestrator types and versions available for upgrade.
    :type upgrades:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        'kubernetes_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'upgrades': {'key': 'upgrades', 'type': '[ManagedClusterPoolUpgradeProfileUpgradesItem]'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "OSType"] = "Linux",
        name: Optional[str] = None,
        upgrades: Optional[List["ManagedClusterPoolUpgradeProfileUpgradesItem"]] = None,
        **kwargs
    ):
        super(ManagedClusterPoolUpgradeProfile, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades


class ManagedClusterPoolUpgradeProfileUpgradesItem(msrest.serialization.Model):
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :param kubernetes_version: Kubernetes version (major, minor, patch).
    :type kubernetes_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _attribute_map = {
        'kubernetes_version': {'key': 'kubernetesVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        super(ManagedClusterPoolUpgradeProfileUpgradesItem, self).__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class ManagedClusterPropertiesAutoScalerProfile(msrest.serialization.Model):
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :param balance_similar_node_groups:
    :type balance_similar_node_groups: str
    :param scan_interval:
    :type scan_interval: str
    :param scale_down_delay_after_add:
    :type scale_down_delay_after_add: str
    :param scale_down_delay_after_delete:
    :type scale_down_delay_after_delete: str
    :param scale_down_delay_after_failure:
    :type scale_down_delay_after_failure: str
    :param scale_down_unneeded_time:
    :type scale_down_unneeded_time: str
    :param scale_down_unready_time:
    :type scale_down_unready_time: str
    :param scale_down_utilization_threshold:
    :type scale_down_utilization_threshold: str
    :param max_graceful_termination_sec:
    :type max_graceful_termination_sec: str
    """

    _attribute_map = {
        'balance_similar_node_groups': {'key': 'balance-similar-node-groups', 'type': 'str'},
        'scan_interval': {'key': 'scan-interval', 'type': 'str'},
        'scale_down_delay_after_add': {'key': 'scale-down-delay-after-add', 'type': 'str'},
        'scale_down_delay_after_delete': {'key': 'scale-down-delay-after-delete', 'type': 'str'},
        'scale_down_delay_after_failure': {'key': 'scale-down-delay-after-failure', 'type': 'str'},
        'scale_down_unneeded_time': {'key': 'scale-down-unneeded-time', 'type': 'str'},
        'scale_down_unready_time': {'key': 'scale-down-unready-time', 'type': 'str'},
        'scale_down_utilization_threshold': {'key': 'scale-down-utilization-threshold', 'type': 'str'},
        'max_graceful_termination_sec': {'key': 'max-graceful-termination-sec', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        balance_similar_node_groups: Optional[str] = None,
        scan_interval: Optional[str] = None,
        scale_down_delay_after_add: Optional[str] = None,
        scale_down_delay_after_delete: Optional[str] = None,
        scale_down_delay_after_failure: Optional[str] = None,
        scale_down_unneeded_time: Optional[str] = None,
        scale_down_unready_time: Optional[str] = None,
        scale_down_utilization_threshold: Optional[str] = None,
        max_graceful_termination_sec: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterPropertiesAutoScalerProfile, self).__init__(**kwargs)
        self.balance_similar_node_groups = balance_similar_node_groups
        self.scan_interval = scan_interval
        self.scale_down_delay_after_add = scale_down_delay_after_add
        self.scale_down_delay_after_delete = scale_down_delay_after_delete
        self.scale_down_delay_after_failure = scale_down_delay_after_failure
        self.scale_down_unneeded_time = scale_down_unneeded_time
        self.scale_down_unready_time = scale_down_unready_time
        self.scale_down_utilization_threshold = scale_down_utilization_threshold
        self.max_graceful_termination_sec = max_graceful_termination_sec


class ManagedClusterPropertiesIdentityProfileValue(UserAssignedIdentity):
    """ManagedClusterPropertiesIdentityProfileValue.

    :param resource_id: The resource id of the user assigned identity.
    :type resource_id: str
    :param client_id: The client id of the user assigned identity.
    :type client_id: str
    :param object_id: The object id of the user assigned identity.
    :type object_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterPropertiesIdentityProfileValue, self).__init__(resource_id=resource_id, client_id=client_id, object_id=object_id, **kwargs)


class ManagedClusterServicePrincipalProfile(msrest.serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure APIs.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. The ID for the service principal.
    :type client_id: str
    :param secret: The secret password associated with the service principal in plain text.
    :type secret: str
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secret: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterServicePrincipalProfile, self).__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret


class ManagedClusterSKU(msrest.serialization.Model):
    """ManagedClusterSKU.

    :param name: Name of a managed cluster SKU. Possible values include: "Basic".
    :type name: str or ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKUName
    :param tier: Tier of a managed cluster SKU. Possible values include: "Paid", "Free".
    :type tier: str or ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "ManagedClusterSKUName"]] = None,
        tier: Optional[Union[str, "ManagedClusterSKUTier"]] = None,
        **kwargs
    ):
        super(ManagedClusterSKU, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class ManagedClusterUpgradeProfile(msrest.serialization.Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of upgrade profile.
    :vartype id: str
    :ivar name: Name of upgrade profile.
    :vartype name: str
    :ivar type: Type of upgrade profile.
    :vartype type: str
    :param control_plane_profile: Required. The list of available upgrade versions for the control
     plane.
    :type control_plane_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfile
    :param agent_pool_profiles: Required. The list of available upgrade versions for agent pools.
    :type agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'control_plane_profile': {'required': True},
        'agent_pool_profiles': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'control_plane_profile': {'key': 'properties.controlPlaneProfile', 'type': 'ManagedClusterPoolUpgradeProfile'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ManagedClusterPoolUpgradeProfile]'},
    }

    def __init__(
        self,
        *,
        control_plane_profile: "ManagedClusterPoolUpgradeProfile",
        agent_pool_profiles: List["ManagedClusterPoolUpgradeProfile"],
        **kwargs
    ):
        super(ManagedClusterUpgradeProfile, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles


class ManagedClusterWindowsProfile(msrest.serialization.Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_username: Required. Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **restriction:** Cannot end in "." :code:`<br>`:code:`<br>`
     **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
     "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
     "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
     "sys", "test2", "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1
     character :code:`<br>`:code:`<br>` **Max-length:** 20 characters.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
     **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
    :type admin_password: str
    """

    _validation = {
        'admin_username': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        admin_password: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterWindowsProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password


class OperationListResult(msrest.serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.containerservice.v2020_04_01.models.OperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None


class OperationValue(msrest.serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class ResourceReference(msrest.serialization.Model):
    """A reference to an Azure resource.

    :param id: The fully qualified Azure resource id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags
