# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccountInfo(_serialization.Model):
    """Account Info of the NewRelic account.

    :ivar account_id: Account id.
    :vartype account_id: str
    :ivar ingestion_key: ingestion key of account.
    :vartype ingestion_key: str
    :ivar region: NewRelic account region.
    :vartype region: str
    """

    _attribute_map = {
        "account_id": {"key": "accountId", "type": "str"},
        "ingestion_key": {"key": "ingestionKey", "type": "str"},
        "region": {"key": "region", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        ingestion_key: Optional[str] = None,
        region: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword account_id: Account id.
        :paramtype account_id: str
        :keyword ingestion_key: ingestion key of account.
        :paramtype ingestion_key: str
        :keyword region: NewRelic account region.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.account_id = account_id
        self.ingestion_key = ingestion_key
        self.region = region


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class AccountResource(ProxyResource):
    """The details of a account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    :ivar organization_id: organization id.
    :vartype organization_id: str
    :ivar account_id: account id.
    :vartype account_id: str
    :ivar account_name: account name.
    :vartype account_name: str
    :ivar region: region.
    :vartype region: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "organization_id": {"key": "properties.organizationId", "type": "str"},
        "account_id": {"key": "properties.accountId", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "region": {"key": "properties.region", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization_id: Optional[str] = None,
        account_id: Optional[str] = None,
        account_name: Optional[str] = None,
        region: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: organization id.
        :paramtype organization_id: str
        :keyword account_id: account id.
        :paramtype account_id: str
        :keyword account_name: account name.
        :paramtype account_name: str
        :keyword region: region.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id
        self.account_id = account_id
        self.account_name = account_name
        self.region = region


class AccountsListResponse(_serialization.Model):
    """Response of get all accounts Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The AccountResource items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.AccountResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AccountResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AccountResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AccountResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.AccountResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AppServiceInfo(_serialization.Model):
    """Details of VM Resource having NewRelic OneAgent installed.

    :ivar azure_resource_id: Azure App service resource ID.
    :vartype azure_resource_id: str
    :ivar agent_version: Version of the NewRelic agent installed on the App service.
    :vartype agent_version: str
    :ivar agent_status: Status of the NewRelic agent installed on the App service.
    :vartype agent_status: str
    """

    _attribute_map = {
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "agent_status": {"key": "agentStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_resource_id: Optional[str] = None,
        agent_version: Optional[str] = None,
        agent_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_resource_id: Azure App service resource ID.
        :paramtype azure_resource_id: str
        :keyword agent_version: Version of the NewRelic agent installed on the App service.
        :paramtype agent_version: str
        :keyword agent_status: Status of the NewRelic agent installed on the App service.
        :paramtype agent_status: str
        """
        super().__init__(**kwargs)
        self.azure_resource_id = azure_resource_id
        self.agent_version = agent_version
        self.agent_status = agent_status


class AppServicesGetParameter(_serialization.Model):
    """App services Get Parameter specification.

    All required parameters must be populated in order to send to Azure.

    :ivar request: The details of the app services get request. Required.
    :vartype request: ~azure.mgmt.newrelicobservability.models.AppServicesGetRequest
    """

    _validation = {
        "request": {"required": True},
    }

    _attribute_map = {
        "request": {"key": "request", "type": "AppServicesGetRequest"},
    }

    def __init__(self, *, request: "_models.AppServicesGetRequest", **kwargs: Any) -> None:
        """
        :keyword request: The details of the app services get request. Required.
        :paramtype request: ~azure.mgmt.newrelicobservability.models.AppServicesGetRequest
        """
        super().__init__(**kwargs)
        self.request = request


class AppServicesGetRequest(_serialization.Model):
    """Request of a app services get Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar azure_resource_ids: Azure resource IDs.
    :vartype azure_resource_ids: list[str]
    :ivar user_email: User Email. Required.
    :vartype user_email: str
    """

    _validation = {
        "user_email": {"required": True, "pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "azure_resource_ids": {"key": "azureResourceIds", "type": "[str]"},
        "user_email": {"key": "userEmail", "type": "str"},
    }

    def __init__(self, *, user_email: str, azure_resource_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword azure_resource_ids: Azure resource IDs.
        :paramtype azure_resource_ids: list[str]
        :keyword user_email: User Email. Required.
        :paramtype user_email: str
        """
        super().__init__(**kwargs)
        self.azure_resource_ids = azure_resource_ids
        self.user_email = user_email


class AppServicesListResponse(_serialization.Model):
    """Response of a list app services Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The AppServiceInfo items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.AppServiceInfo]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AppServiceInfo"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AppServiceInfo items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.AppServiceInfo]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.newrelicobservability.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.newrelicobservability.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.newrelicobservability.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.newrelicobservability.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FilteringTag(_serialization.Model):
    """The definition of a filtering tag. Filtering tags are used for capturing resources and
    include/exclude them from being monitored.

    :ivar name: The name (also known as the key) of the tag.
    :vartype name: str
    :ivar value: The value of the tag.
    :vartype value: str
    :ivar action: Valid actions for a filtering tag. Exclusion takes priority over inclusion. Known
     values are: "Include" and "Exclude".
    :vartype action: str or ~azure.mgmt.newrelicobservability.models.TagAction
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        action: Optional[Union[str, "_models.TagAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name (also known as the key) of the tag.
        :paramtype name: str
        :keyword value: The value of the tag.
        :paramtype value: str
        :keyword action: Valid actions for a filtering tag. Exclusion takes priority over inclusion.
         Known values are: "Include" and "Exclude".
        :paramtype action: str or ~azure.mgmt.newrelicobservability.models.TagAction
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.action = action


class HostsGetParameter(_serialization.Model):
    """Host Get Parameter specification.

    All required parameters must be populated in order to send to Azure.

    :ivar request: The details of the Hosts get request. Required.
    :vartype request: ~azure.mgmt.newrelicobservability.models.HostsGetRequest
    """

    _validation = {
        "request": {"required": True},
    }

    _attribute_map = {
        "request": {"key": "request", "type": "HostsGetRequest"},
    }

    def __init__(self, *, request: "_models.HostsGetRequest", **kwargs: Any) -> None:
        """
        :keyword request: The details of the Hosts get request. Required.
        :paramtype request: ~azure.mgmt.newrelicobservability.models.HostsGetRequest
        """
        super().__init__(**kwargs)
        self.request = request


class HostsGetRequest(_serialization.Model):
    """Request of a Hosts get Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar vm_ids: VM resource IDs.
    :vartype vm_ids: list[str]
    :ivar user_email: User Email. Required.
    :vartype user_email: str
    """

    _validation = {
        "user_email": {"required": True, "pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "vm_ids": {"key": "vmIds", "type": "[str]"},
        "user_email": {"key": "userEmail", "type": "str"},
    }

    def __init__(self, *, user_email: str, vm_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword vm_ids: VM resource IDs.
        :paramtype vm_ids: list[str]
        :keyword user_email: User Email. Required.
        :paramtype user_email: str
        """
        super().__init__(**kwargs)
        self.vm_ids = vm_ids
        self.user_email = user_email


class LogRules(_serialization.Model):
    """Set of rules for sending logs for the Monitor resource.

    :ivar send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource. Known
     values are: "Enabled" and "Disabled".
    :vartype send_aad_logs: str or ~azure.mgmt.newrelicobservability.models.SendAadLogsStatus
    :ivar send_subscription_logs: Flag specifying if subscription logs should be sent for the
     Monitor resource. Known values are: "Enabled" and "Disabled".
    :vartype send_subscription_logs: str or
     ~azure.mgmt.newrelicobservability.models.SendSubscriptionLogsStatus
    :ivar send_activity_logs: Flag specifying if activity logs from Azure resources should be sent
     for the Monitor resource. Known values are: "Enabled" and "Disabled".
    :vartype send_activity_logs: str or
     ~azure.mgmt.newrelicobservability.models.SendActivityLogsStatus
    :ivar filtering_tags: List of filtering tags to be used for capturing logs. This only takes
     effect if SendActivityLogs flag is enabled. If empty, all resources will be captured.
     If only Exclude action is specified, the rules will apply to the list of all available
     resources. If Include actions are specified, the rules will only include resources with the
     associated tags.
    :vartype filtering_tags: list[~azure.mgmt.newrelicobservability.models.FilteringTag]
    """

    _attribute_map = {
        "send_aad_logs": {"key": "sendAadLogs", "type": "str"},
        "send_subscription_logs": {"key": "sendSubscriptionLogs", "type": "str"},
        "send_activity_logs": {"key": "sendActivityLogs", "type": "str"},
        "filtering_tags": {"key": "filteringTags", "type": "[FilteringTag]"},
    }

    def __init__(
        self,
        *,
        send_aad_logs: Optional[Union[str, "_models.SendAadLogsStatus"]] = None,
        send_subscription_logs: Optional[Union[str, "_models.SendSubscriptionLogsStatus"]] = None,
        send_activity_logs: Optional[Union[str, "_models.SendActivityLogsStatus"]] = None,
        filtering_tags: Optional[List["_models.FilteringTag"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
         Known values are: "Enabled" and "Disabled".
        :paramtype send_aad_logs: str or ~azure.mgmt.newrelicobservability.models.SendAadLogsStatus
        :keyword send_subscription_logs: Flag specifying if subscription logs should be sent for the
         Monitor resource. Known values are: "Enabled" and "Disabled".
        :paramtype send_subscription_logs: str or
         ~azure.mgmt.newrelicobservability.models.SendSubscriptionLogsStatus
        :keyword send_activity_logs: Flag specifying if activity logs from Azure resources should be
         sent for the Monitor resource. Known values are: "Enabled" and "Disabled".
        :paramtype send_activity_logs: str or
         ~azure.mgmt.newrelicobservability.models.SendActivityLogsStatus
        :keyword filtering_tags: List of filtering tags to be used for capturing logs. This only takes
         effect if SendActivityLogs flag is enabled. If empty, all resources will be captured.
         If only Exclude action is specified, the rules will apply to the list of all available
         resources. If Include actions are specified, the rules will only include resources with the
         associated tags.
        :paramtype filtering_tags: list[~azure.mgmt.newrelicobservability.models.FilteringTag]
        """
        super().__init__(**kwargs)
        self.send_aad_logs = send_aad_logs
        self.send_subscription_logs = send_subscription_logs
        self.send_activity_logs = send_activity_logs
        self.filtering_tags = filtering_tags


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.newrelicobservability.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.newrelicobservability.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.newrelicobservability.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.newrelicobservability.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MetricRules(_serialization.Model):
    """Set of rules for sending metrics for the Monitor resource.

    :ivar send_metrics: Flag specifying if metrics should be sent for the Monitor resource. Known
     values are: "Enabled" and "Disabled".
    :vartype send_metrics: str or ~azure.mgmt.newrelicobservability.models.SendMetricsStatus
    :ivar filtering_tags: List of filtering tags to be used for capturing metrics.
    :vartype filtering_tags: list[~azure.mgmt.newrelicobservability.models.FilteringTag]
    :ivar user_email: User Email.
    :vartype user_email: str
    """

    _validation = {
        "user_email": {"pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "send_metrics": {"key": "sendMetrics", "type": "str"},
        "filtering_tags": {"key": "filteringTags", "type": "[FilteringTag]"},
        "user_email": {"key": "userEmail", "type": "str"},
    }

    def __init__(
        self,
        *,
        send_metrics: Optional[Union[str, "_models.SendMetricsStatus"]] = None,
        filtering_tags: Optional[List["_models.FilteringTag"]] = None,
        user_email: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword send_metrics: Flag specifying if metrics should be sent for the Monitor resource.
         Known values are: "Enabled" and "Disabled".
        :paramtype send_metrics: str or ~azure.mgmt.newrelicobservability.models.SendMetricsStatus
        :keyword filtering_tags: List of filtering tags to be used for capturing metrics.
        :paramtype filtering_tags: list[~azure.mgmt.newrelicobservability.models.FilteringTag]
        :keyword user_email: User Email.
        :paramtype user_email: str
        """
        super().__init__(**kwargs)
        self.send_metrics = send_metrics
        self.filtering_tags = filtering_tags
        self.user_email = user_email


class MetricsRequest(_serialization.Model):
    """Request of get metrics Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar user_email: User Email. Required.
    :vartype user_email: str
    """

    _validation = {
        "user_email": {"required": True, "pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "user_email": {"key": "userEmail", "type": "str"},
    }

    def __init__(self, *, user_email: str, **kwargs: Any) -> None:
        """
        :keyword user_email: User Email. Required.
        :paramtype user_email: str
        """
        super().__init__(**kwargs)
        self.user_email = user_email


class MetricsRequestParameter(_serialization.Model):
    """Get Metrics Status Parameter specification.

    All required parameters must be populated in order to send to Azure.

    :ivar request: The details of the get metrics status request. Required.
    :vartype request: ~azure.mgmt.newrelicobservability.models.MetricsRequest
    """

    _validation = {
        "request": {"required": True},
    }

    _attribute_map = {
        "request": {"key": "request", "type": "MetricsRequest"},
    }

    def __init__(self, *, request: "_models.MetricsRequest", **kwargs: Any) -> None:
        """
        :keyword request: The details of the get metrics status request. Required.
        :paramtype request: ~azure.mgmt.newrelicobservability.models.MetricsRequest
        """
        super().__init__(**kwargs)
        self.request = request


class MetricsStatusRequest(_serialization.Model):
    """Request of get metrics status Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar azure_resource_ids: Azure resource IDs.
    :vartype azure_resource_ids: list[str]
    :ivar user_email: User Email. Required.
    :vartype user_email: str
    """

    _validation = {
        "user_email": {"required": True, "pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "azure_resource_ids": {"key": "azureResourceIds", "type": "[str]"},
        "user_email": {"key": "userEmail", "type": "str"},
    }

    def __init__(self, *, user_email: str, azure_resource_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword azure_resource_ids: Azure resource IDs.
        :paramtype azure_resource_ids: list[str]
        :keyword user_email: User Email. Required.
        :paramtype user_email: str
        """
        super().__init__(**kwargs)
        self.azure_resource_ids = azure_resource_ids
        self.user_email = user_email


class MetricsStatusRequestParameter(_serialization.Model):
    """Get Metrics Status Parameter specification.

    All required parameters must be populated in order to send to Azure.

    :ivar request: The details of the get metrics status request. Required.
    :vartype request: ~azure.mgmt.newrelicobservability.models.MetricsStatusRequest
    """

    _validation = {
        "request": {"required": True},
    }

    _attribute_map = {
        "request": {"key": "request", "type": "MetricsStatusRequest"},
    }

    def __init__(self, *, request: "_models.MetricsStatusRequest", **kwargs: Any) -> None:
        """
        :keyword request: The details of the get metrics status request. Required.
        :paramtype request: ~azure.mgmt.newrelicobservability.models.MetricsStatusRequest
        """
        super().__init__(**kwargs)
        self.request = request


class MetricsStatusResponse(_serialization.Model):
    """Response of get metrics status Operation.

    :ivar azure_resource_ids: Azure resource IDs.
    :vartype azure_resource_ids: list[str]
    """

    _attribute_map = {
        "azure_resource_ids": {"key": "azureResourceIds", "type": "[str]"},
    }

    def __init__(self, *, azure_resource_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword azure_resource_ids: Azure resource IDs.
        :paramtype azure_resource_ids: list[str]
        """
        super().__init__(**kwargs)
        self.azure_resource_ids = azure_resource_ids


class MonitoredResource(_serialization.Model):
    """Details of resource being monitored by NewRelic monitor resource.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar sending_metrics: Flag indicating if resource is sending metrics to NewRelic. Known values
     are: "Enabled" and "Disabled".
    :vartype sending_metrics: str or ~azure.mgmt.newrelicobservability.models.SendingMetricsStatus
    :ivar reason_for_metrics_status: Reason for why the resource is sending metrics (or why it is
     not sending).
    :vartype reason_for_metrics_status: str
    :ivar sending_logs: Flag indicating if resource is sending logs to NewRelic. Known values are:
     "Enabled" and "Disabled".
    :vartype sending_logs: str or ~azure.mgmt.newrelicobservability.models.SendingLogsStatus
    :ivar reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
     sending).
    :vartype reason_for_logs_status: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "sending_metrics": {"key": "sendingMetrics", "type": "str"},
        "reason_for_metrics_status": {"key": "reasonForMetricsStatus", "type": "str"},
        "sending_logs": {"key": "sendingLogs", "type": "str"},
        "reason_for_logs_status": {"key": "reasonForLogsStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        sending_metrics: Optional[Union[str, "_models.SendingMetricsStatus"]] = None,
        reason_for_metrics_status: Optional[str] = None,
        sending_logs: Optional[Union[str, "_models.SendingLogsStatus"]] = None,
        reason_for_logs_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ARM id of the resource.
        :paramtype id: str
        :keyword sending_metrics: Flag indicating if resource is sending metrics to NewRelic. Known
         values are: "Enabled" and "Disabled".
        :paramtype sending_metrics: str or
         ~azure.mgmt.newrelicobservability.models.SendingMetricsStatus
        :keyword reason_for_metrics_status: Reason for why the resource is sending metrics (or why it
         is not sending).
        :paramtype reason_for_metrics_status: str
        :keyword sending_logs: Flag indicating if resource is sending logs to NewRelic. Known values
         are: "Enabled" and "Disabled".
        :paramtype sending_logs: str or ~azure.mgmt.newrelicobservability.models.SendingLogsStatus
        :keyword reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
         sending).
        :paramtype reason_for_logs_status: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.sending_metrics = sending_metrics
        self.reason_for_metrics_status = reason_for_metrics_status
        self.sending_logs = sending_logs
        self.reason_for_logs_status = reason_for_logs_status


class MonitoredResourceListResponse(_serialization.Model):
    """List of all the resources being monitored by NewRelic monitor resource.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The MonitoredResource items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.MonitoredResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoredResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.MonitoredResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The MonitoredResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.MonitoredResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NewRelicAccountProperties(_serialization.Model):
    """Properties of the NewRelic account.

    :ivar user_id: User id.
    :vartype user_id: str
    :ivar account_info: NewRelic Account Information.
    :vartype account_info: ~azure.mgmt.newrelicobservability.models.AccountInfo
    :ivar organization_info: NewRelic Organization Information.
    :vartype organization_info: ~azure.mgmt.newrelicobservability.models.OrganizationInfo
    :ivar single_sign_on_properties: date when plan was applied.
    :vartype single_sign_on_properties:
     ~azure.mgmt.newrelicobservability.models.NewRelicSingleSignOnProperties
    """

    _attribute_map = {
        "user_id": {"key": "userId", "type": "str"},
        "account_info": {"key": "accountInfo", "type": "AccountInfo"},
        "organization_info": {"key": "organizationInfo", "type": "OrganizationInfo"},
        "single_sign_on_properties": {"key": "singleSignOnProperties", "type": "NewRelicSingleSignOnProperties"},
    }

    def __init__(
        self,
        *,
        user_id: Optional[str] = None,
        account_info: Optional["_models.AccountInfo"] = None,
        organization_info: Optional["_models.OrganizationInfo"] = None,
        single_sign_on_properties: Optional["_models.NewRelicSingleSignOnProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_id: User id.
        :paramtype user_id: str
        :keyword account_info: NewRelic Account Information.
        :paramtype account_info: ~azure.mgmt.newrelicobservability.models.AccountInfo
        :keyword organization_info: NewRelic Organization Information.
        :paramtype organization_info: ~azure.mgmt.newrelicobservability.models.OrganizationInfo
        :keyword single_sign_on_properties: date when plan was applied.
        :paramtype single_sign_on_properties:
         ~azure.mgmt.newrelicobservability.models.NewRelicSingleSignOnProperties
        """
        super().__init__(**kwargs)
        self.user_id = user_id
        self.account_info = account_info
        self.organization_info = organization_info
        self.single_sign_on_properties = single_sign_on_properties


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class NewRelicMonitorResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A Monitor Resource by NewRelic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.newrelicobservability.models.ManagedServiceIdentity
    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.newrelicobservability.models.ProvisioningState
    :ivar monitoring_status: MonitoringStatus of the resource. Known values are: "Enabled" and
     "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.newrelicobservability.models.MonitoringStatus
    :ivar marketplace_subscription_status: NewRelic Organization properties of the resource. Known
     values are: "Active" and "Suspended".
    :vartype marketplace_subscription_status: str or
     ~azure.mgmt.newrelicobservability.models.MarketplaceSubscriptionStatus
    :ivar marketplace_subscription_id: Marketplace Subscription Id.
    :vartype marketplace_subscription_id: str
    :ivar new_relic_account_properties: MarketplaceSubscriptionStatus of the resource.
    :vartype new_relic_account_properties:
     ~azure.mgmt.newrelicobservability.models.NewRelicAccountProperties
    :ivar user_info: User Info.
    :vartype user_info: ~azure.mgmt.newrelicobservability.models.UserInfo
    :ivar plan_data: Plan details.
    :vartype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
    :ivar liftr_resource_category: Liftr resource category. Known values are: "Unknown" and
     "MonitorLogs".
    :vartype liftr_resource_category: str or
     ~azure.mgmt.newrelicobservability.models.LiftrResourceCategories
    :ivar liftr_resource_preference: Liftr resource preference. The priority of the resource.
    :vartype liftr_resource_preference: int
    :ivar org_creation_source: Source of org creation. Known values are: "LIFTR" and "NEWRELIC".
    :vartype org_creation_source: str or ~azure.mgmt.newrelicobservability.models.OrgCreationSource
    :ivar account_creation_source: Source of account creation. Known values are: "LIFTR" and
     "NEWRELIC".
    :vartype account_creation_source: str or
     ~azure.mgmt.newrelicobservability.models.AccountCreationSource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "monitoring_status": {"readonly": True},
        "marketplace_subscription_status": {"readonly": True},
        "marketplace_subscription_id": {"readonly": True},
        "liftr_resource_category": {"readonly": True},
        "liftr_resource_preference": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "monitoring_status": {"key": "properties.monitoringStatus", "type": "str"},
        "marketplace_subscription_status": {"key": "properties.marketplaceSubscriptionStatus", "type": "str"},
        "marketplace_subscription_id": {"key": "properties.marketplaceSubscriptionId", "type": "str"},
        "new_relic_account_properties": {
            "key": "properties.newRelicAccountProperties",
            "type": "NewRelicAccountProperties",
        },
        "user_info": {"key": "properties.userInfo", "type": "UserInfo"},
        "plan_data": {"key": "properties.planData", "type": "PlanData"},
        "liftr_resource_category": {"key": "properties.liftrResourceCategory", "type": "str"},
        "liftr_resource_preference": {"key": "properties.liftrResourcePreference", "type": "int"},
        "org_creation_source": {"key": "properties.orgCreationSource", "type": "str"},
        "account_creation_source": {"key": "properties.accountCreationSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        new_relic_account_properties: Optional["_models.NewRelicAccountProperties"] = None,
        user_info: Optional["_models.UserInfo"] = None,
        plan_data: Optional["_models.PlanData"] = None,
        org_creation_source: Optional[Union[str, "_models.OrgCreationSource"]] = None,
        account_creation_source: Optional[Union[str, "_models.AccountCreationSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.newrelicobservability.models.ManagedServiceIdentity
        :keyword new_relic_account_properties: MarketplaceSubscriptionStatus of the resource.
        :paramtype new_relic_account_properties:
         ~azure.mgmt.newrelicobservability.models.NewRelicAccountProperties
        :keyword user_info: User Info.
        :paramtype user_info: ~azure.mgmt.newrelicobservability.models.UserInfo
        :keyword plan_data: Plan details.
        :paramtype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
        :keyword org_creation_source: Source of org creation. Known values are: "LIFTR" and "NEWRELIC".
        :paramtype org_creation_source: str or
         ~azure.mgmt.newrelicobservability.models.OrgCreationSource
        :keyword account_creation_source: Source of account creation. Known values are: "LIFTR" and
         "NEWRELIC".
        :paramtype account_creation_source: str or
         ~azure.mgmt.newrelicobservability.models.AccountCreationSource
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.monitoring_status = None
        self.marketplace_subscription_status = None
        self.marketplace_subscription_id = None
        self.new_relic_account_properties = new_relic_account_properties
        self.user_info = user_info
        self.plan_data = plan_data
        self.liftr_resource_category = None
        self.liftr_resource_preference = None
        self.org_creation_source = org_creation_source
        self.account_creation_source = account_creation_source


class NewRelicMonitorResourceListResult(_serialization.Model):
    """The response of a NewRelicMonitorResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The NewRelicMonitorResource items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.NewRelicMonitorResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NewRelicMonitorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.NewRelicMonitorResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The NewRelicMonitorResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.NewRelicMonitorResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NewRelicMonitorResourceUpdate(_serialization.Model):
    """The type used for update operations of the NewRelicMonitorResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.newrelicobservability.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar new_relic_account_properties: MarketplaceSubscriptionStatus of the resource.
    :vartype new_relic_account_properties:
     ~azure.mgmt.newrelicobservability.models.NewRelicAccountProperties
    :ivar user_info: User Info.
    :vartype user_info: ~azure.mgmt.newrelicobservability.models.UserInfo
    :ivar plan_data: Plan details.
    :vartype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
    :ivar org_creation_source: Source of org creation. Known values are: "LIFTR" and "NEWRELIC".
    :vartype org_creation_source: str or ~azure.mgmt.newrelicobservability.models.OrgCreationSource
    :ivar account_creation_source: Source of account creation. Known values are: "LIFTR" and
     "NEWRELIC".
    :vartype account_creation_source: str or
     ~azure.mgmt.newrelicobservability.models.AccountCreationSource
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "new_relic_account_properties": {
            "key": "properties.newRelicAccountProperties",
            "type": "NewRelicAccountProperties",
        },
        "user_info": {"key": "properties.userInfo", "type": "UserInfo"},
        "plan_data": {"key": "properties.planData", "type": "PlanData"},
        "org_creation_source": {"key": "properties.orgCreationSource", "type": "str"},
        "account_creation_source": {"key": "properties.accountCreationSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        new_relic_account_properties: Optional["_models.NewRelicAccountProperties"] = None,
        user_info: Optional["_models.UserInfo"] = None,
        plan_data: Optional["_models.PlanData"] = None,
        org_creation_source: Optional[Union[str, "_models.OrgCreationSource"]] = None,
        account_creation_source: Optional[Union[str, "_models.AccountCreationSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.newrelicobservability.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword new_relic_account_properties: MarketplaceSubscriptionStatus of the resource.
        :paramtype new_relic_account_properties:
         ~azure.mgmt.newrelicobservability.models.NewRelicAccountProperties
        :keyword user_info: User Info.
        :paramtype user_info: ~azure.mgmt.newrelicobservability.models.UserInfo
        :keyword plan_data: Plan details.
        :paramtype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
        :keyword org_creation_source: Source of org creation. Known values are: "LIFTR" and "NEWRELIC".
        :paramtype org_creation_source: str or
         ~azure.mgmt.newrelicobservability.models.OrgCreationSource
        :keyword account_creation_source: Source of account creation. Known values are: "LIFTR" and
         "NEWRELIC".
        :paramtype account_creation_source: str or
         ~azure.mgmt.newrelicobservability.models.AccountCreationSource
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.new_relic_account_properties = new_relic_account_properties
        self.user_info = user_info
        self.plan_data = plan_data
        self.org_creation_source = org_creation_source
        self.account_creation_source = account_creation_source


class NewRelicSingleSignOnProperties(_serialization.Model):
    """Single sign on Info of the NewRelic account.

    :ivar single_sign_on_state: Single sign-on state. Known values are: "Initial", "Enable",
     "Disable", and "Existing".
    :vartype single_sign_on_state: str or
     ~azure.mgmt.newrelicobservability.models.SingleSignOnStates
    :ivar enterprise_app_id: The Id of the Enterprise App used for Single sign-on.
    :vartype enterprise_app_id: str
    :ivar single_sign_on_url: The login URL specific to this NewRelic Organization.
    :vartype single_sign_on_url: str
    :ivar provisioning_state: Provisioning state. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.newrelicobservability.models.ProvisioningState
    """

    _attribute_map = {
        "single_sign_on_state": {"key": "singleSignOnState", "type": "str"},
        "enterprise_app_id": {"key": "enterpriseAppId", "type": "str"},
        "single_sign_on_url": {"key": "singleSignOnUrl", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        single_sign_on_state: Optional[Union[str, "_models.SingleSignOnStates"]] = None,
        enterprise_app_id: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword single_sign_on_state: Single sign-on state. Known values are: "Initial", "Enable",
         "Disable", and "Existing".
        :paramtype single_sign_on_state: str or
         ~azure.mgmt.newrelicobservability.models.SingleSignOnStates
        :keyword enterprise_app_id: The Id of the Enterprise App used for Single sign-on.
        :paramtype enterprise_app_id: str
        :keyword single_sign_on_url: The login URL specific to this NewRelic Organization.
        :paramtype single_sign_on_url: str
        :keyword provisioning_state: Provisioning state. Known values are: "Accepted", "Creating",
         "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
        :paramtype provisioning_state: str or
         ~azure.mgmt.newrelicobservability.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.single_sign_on_state = single_sign_on_state
        self.enterprise_app_id = enterprise_app_id
        self.single_sign_on_url = single_sign_on_url
        self.provisioning_state = provisioning_state


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.newrelicobservability.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.newrelicobservability.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.newrelicobservability.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.newrelicobservability.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OrganizationInfo(_serialization.Model):
    """Organization Info of the NewRelic account.

    :ivar organization_id: Organization id.
    :vartype organization_id: str
    """

    _attribute_map = {
        "organization_id": {"key": "organizationId", "type": "str"},
    }

    def __init__(self, *, organization_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword organization_id: Organization id.
        :paramtype organization_id: str
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id


class OrganizationResource(ProxyResource):
    """The details of a Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    :ivar organization_id: organization id.
    :vartype organization_id: str
    :ivar organization_name: organization name.
    :vartype organization_name: str
    :ivar billing_source: Billing source. Known values are: "AZURE" and "NEWRELIC".
    :vartype billing_source: str or ~azure.mgmt.newrelicobservability.models.BillingSource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "organization_id": {"key": "properties.organizationId", "type": "str"},
        "organization_name": {"key": "properties.organizationName", "type": "str"},
        "billing_source": {"key": "properties.billingSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization_id: Optional[str] = None,
        organization_name: Optional[str] = None,
        billing_source: Optional[Union[str, "_models.BillingSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: organization id.
        :paramtype organization_id: str
        :keyword organization_name: organization name.
        :paramtype organization_name: str
        :keyword billing_source: Billing source. Known values are: "AZURE" and "NEWRELIC".
        :paramtype billing_source: str or ~azure.mgmt.newrelicobservability.models.BillingSource
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id
        self.organization_name = organization_name
        self.billing_source = billing_source


class OrganizationsListResponse(_serialization.Model):
    """Response of get all organizations Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The OrganizationResource items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.OrganizationResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OrganizationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.OrganizationResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The OrganizationResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.OrganizationResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PlanData(_serialization.Model):
    """Plan data of NewRelic Monitor resource.

    :ivar usage_type: Different usage type like PAYG/COMMITTED. this could be enum. Known values
     are: "PAYG" and "COMMITTED".
    :vartype usage_type: str or ~azure.mgmt.newrelicobservability.models.UsageType
    :ivar billing_cycle: Different billing cycles like MONTHLY/WEEKLY. this could be enum. Known
     values are: "YEARLY", "MONTHLY", and "WEEKLY".
    :vartype billing_cycle: str or ~azure.mgmt.newrelicobservability.models.BillingCycle
    :ivar plan_details: plan id as published by NewRelic.
    :vartype plan_details: str
    :ivar effective_date: date when plan was applied.
    :vartype effective_date: ~datetime.datetime
    """

    _attribute_map = {
        "usage_type": {"key": "usageType", "type": "str"},
        "billing_cycle": {"key": "billingCycle", "type": "str"},
        "plan_details": {"key": "planDetails", "type": "str"},
        "effective_date": {"key": "effectiveDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        usage_type: Optional[Union[str, "_models.UsageType"]] = None,
        billing_cycle: Optional[Union[str, "_models.BillingCycle"]] = None,
        plan_details: Optional[str] = None,
        effective_date: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword usage_type: Different usage type like PAYG/COMMITTED. this could be enum. Known values
         are: "PAYG" and "COMMITTED".
        :paramtype usage_type: str or ~azure.mgmt.newrelicobservability.models.UsageType
        :keyword billing_cycle: Different billing cycles like MONTHLY/WEEKLY. this could be enum. Known
         values are: "YEARLY", "MONTHLY", and "WEEKLY".
        :paramtype billing_cycle: str or ~azure.mgmt.newrelicobservability.models.BillingCycle
        :keyword plan_details: plan id as published by NewRelic.
        :paramtype plan_details: str
        :keyword effective_date: date when plan was applied.
        :paramtype effective_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.usage_type = usage_type
        self.billing_cycle = billing_cycle
        self.plan_details = plan_details
        self.effective_date = effective_date


class PlanDataListResponse(_serialization.Model):
    """Response of get all plan data Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The PlanDataResource items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.PlanDataResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PlanDataResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PlanDataResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The PlanDataResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.PlanDataResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PlanDataResource(ProxyResource):
    """The details of a PlanData resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    :ivar plan_data: Plan details.
    :vartype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
    :ivar org_creation_source: Source of org creation. Known values are: "LIFTR" and "NEWRELIC".
    :vartype org_creation_source: str or ~azure.mgmt.newrelicobservability.models.OrgCreationSource
    :ivar account_creation_source: Source of account creation. Known values are: "LIFTR" and
     "NEWRELIC".
    :vartype account_creation_source: str or
     ~azure.mgmt.newrelicobservability.models.AccountCreationSource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "plan_data": {"key": "properties.planData", "type": "PlanData"},
        "org_creation_source": {"key": "properties.orgCreationSource", "type": "str"},
        "account_creation_source": {"key": "properties.accountCreationSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        plan_data: Optional["_models.PlanData"] = None,
        org_creation_source: Optional[Union[str, "_models.OrgCreationSource"]] = None,
        account_creation_source: Optional[Union[str, "_models.AccountCreationSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword plan_data: Plan details.
        :paramtype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
        :keyword org_creation_source: Source of org creation. Known values are: "LIFTR" and "NEWRELIC".
        :paramtype org_creation_source: str or
         ~azure.mgmt.newrelicobservability.models.OrgCreationSource
        :keyword account_creation_source: Source of account creation. Known values are: "LIFTR" and
         "NEWRELIC".
        :paramtype account_creation_source: str or
         ~azure.mgmt.newrelicobservability.models.AccountCreationSource
        """
        super().__init__(**kwargs)
        self.plan_data = plan_data
        self.org_creation_source = org_creation_source
        self.account_creation_source = account_creation_source


class SwitchBillingParameter(_serialization.Model):
    """Switch Billing Parameter specification.

    All required parameters must be populated in order to send to Azure.

    :ivar request: The details of the switch billing request. Required.
    :vartype request: ~azure.mgmt.newrelicobservability.models.SwitchBillingRequest
    """

    _validation = {
        "request": {"required": True},
    }

    _attribute_map = {
        "request": {"key": "request", "type": "SwitchBillingRequest"},
    }

    def __init__(self, *, request: "_models.SwitchBillingRequest", **kwargs: Any) -> None:
        """
        :keyword request: The details of the switch billing request. Required.
        :paramtype request: ~azure.mgmt.newrelicobservability.models.SwitchBillingRequest
        """
        super().__init__(**kwargs)
        self.request = request


class SwitchBillingRequest(_serialization.Model):
    """Request of a switch billing Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar azure_resource_id: Azure resource Id.
    :vartype azure_resource_id: str
    :ivar organization_id: Organization id.
    :vartype organization_id: str
    :ivar plan_data: Plan details.
    :vartype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
    :ivar user_email: User Email. Required.
    :vartype user_email: str
    """

    _validation = {
        "user_email": {"required": True, "pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
        "organization_id": {"key": "organizationId", "type": "str"},
        "plan_data": {"key": "planData", "type": "PlanData"},
        "user_email": {"key": "userEmail", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_email: str,
        azure_resource_id: Optional[str] = None,
        organization_id: Optional[str] = None,
        plan_data: Optional["_models.PlanData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_resource_id: Azure resource Id.
        :paramtype azure_resource_id: str
        :keyword organization_id: Organization id.
        :paramtype organization_id: str
        :keyword plan_data: Plan details.
        :paramtype plan_data: ~azure.mgmt.newrelicobservability.models.PlanData
        :keyword user_email: User Email. Required.
        :paramtype user_email: str
        """
        super().__init__(**kwargs)
        self.azure_resource_id = azure_resource_id
        self.organization_id = organization_id
        self.plan_data = plan_data
        self.user_email = user_email


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.newrelicobservability.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.newrelicobservability.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.newrelicobservability.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.newrelicobservability.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagRule(ProxyResource):
    """A tag rule belonging to NewRelic account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.newrelicobservability.models.SystemData
    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.newrelicobservability.models.ProvisioningState
    :ivar log_rules: Set of rules for sending logs for the Monitor resource.
    :vartype log_rules: ~azure.mgmt.newrelicobservability.models.LogRules
    :ivar metric_rules: Set of rules for sending metrics for the Monitor resource.
    :vartype metric_rules: ~azure.mgmt.newrelicobservability.models.MetricRules
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "log_rules": {"key": "properties.logRules", "type": "LogRules"},
        "metric_rules": {"key": "properties.metricRules", "type": "MetricRules"},
    }

    def __init__(
        self,
        *,
        log_rules: Optional["_models.LogRules"] = None,
        metric_rules: Optional["_models.MetricRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_rules: Set of rules for sending logs for the Monitor resource.
        :paramtype log_rules: ~azure.mgmt.newrelicobservability.models.LogRules
        :keyword metric_rules: Set of rules for sending metrics for the Monitor resource.
        :paramtype metric_rules: ~azure.mgmt.newrelicobservability.models.MetricRules
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.log_rules = log_rules
        self.metric_rules = metric_rules


class TagRuleListResult(_serialization.Model):
    """The response of a TagRule list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The TagRule items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.TagRule]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TagRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TagRule"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The TagRule items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.TagRule]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TagRuleUpdate(_serialization.Model):
    """The type used for update operations of the TagRule.

    :ivar log_rules: Set of rules for sending logs for the Monitor resource.
    :vartype log_rules: ~azure.mgmt.newrelicobservability.models.LogRules
    :ivar metric_rules: Set of rules for sending metrics for the Monitor resource.
    :vartype metric_rules: ~azure.mgmt.newrelicobservability.models.MetricRules
    """

    _attribute_map = {
        "log_rules": {"key": "properties.logRules", "type": "LogRules"},
        "metric_rules": {"key": "properties.metricRules", "type": "MetricRules"},
    }

    def __init__(
        self,
        *,
        log_rules: Optional["_models.LogRules"] = None,
        metric_rules: Optional["_models.MetricRules"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_rules: Set of rules for sending logs for the Monitor resource.
        :paramtype log_rules: ~azure.mgmt.newrelicobservability.models.LogRules
        :keyword metric_rules: Set of rules for sending metrics for the Monitor resource.
        :paramtype metric_rules: ~azure.mgmt.newrelicobservability.models.MetricRules
        """
        super().__init__(**kwargs)
        self.log_rules = log_rules
        self.metric_rules = metric_rules


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserInfo(_serialization.Model):
    """User Info of NewRelic Monitor resource.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email_address: User Email.
    :vartype email_address: str
    :ivar phone_number: Contact phone number.
    :vartype phone_number: str
    :ivar country: country if user.
    :vartype country: str
    """

    _validation = {
        "first_name": {"max_length": 50},
        "last_name": {"max_length": 50},
        "email_address": {"pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
        "phone_number": {"max_length": 40},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        phone_number: Optional[str] = None,
        country: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email_address: User Email.
        :paramtype email_address: str
        :keyword phone_number: Contact phone number.
        :paramtype phone_number: str
        :keyword country: country if user.
        :paramtype country: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.phone_number = phone_number
        self.country = country


class VMExtensionPayload(_serialization.Model):
    """Response of payload to be passed while installing VM agent.

    :ivar ingestion_key: Ingestion key of the account.
    :vartype ingestion_key: str
    """

    _attribute_map = {
        "ingestion_key": {"key": "ingestionKey", "type": "str"},
    }

    def __init__(self, *, ingestion_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ingestion_key: Ingestion key of the account.
        :paramtype ingestion_key: str
        """
        super().__init__(**kwargs)
        self.ingestion_key = ingestion_key


class VMHostsListResponse(_serialization.Model):
    """Response of a list VM Host Operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The VMInfo items on this page. Required.
    :vartype value: list[~azure.mgmt.newrelicobservability.models.VMInfo]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VMInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.VMInfo"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The VMInfo items on this page. Required.
        :paramtype value: list[~azure.mgmt.newrelicobservability.models.VMInfo]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VMInfo(_serialization.Model):
    """Details of VM Resource having NewRelic OneAgent installed.

    :ivar vm_id: Azure VM resource ID.
    :vartype vm_id: str
    :ivar agent_version: Version of the NewRelic agent installed on the VM.
    :vartype agent_version: str
    :ivar agent_status: Status of the NewRelic agent installed on the VM.
    :vartype agent_status: str
    """

    _attribute_map = {
        "vm_id": {"key": "vmId", "type": "str"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "agent_status": {"key": "agentStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        vm_id: Optional[str] = None,
        agent_version: Optional[str] = None,
        agent_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_id: Azure VM resource ID.
        :paramtype vm_id: str
        :keyword agent_version: Version of the NewRelic agent installed on the VM.
        :paramtype agent_version: str
        :keyword agent_status: Status of the NewRelic agent installed on the VM.
        :paramtype agent_status: str
        """
        super().__init__(**kwargs)
        self.vm_id = vm_id
        self.agent_version = agent_version
        self.agent_status = agent_status
