% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmknnIndex-class.R
\docType{class}
\name{KmknnIndex}
\alias{KmknnIndex}
\alias{KmknnIndex-class}
\alias{KmknnIndex_cluster_centers}
\alias{KmknnIndex_cluster_info}
\alias{show,KmknnIndex-method}
\alias{bnorder,KmknnIndex-method}
\title{The KmknnIndex class}
\usage{
KmknnIndex(data, centers, info, order, NAMES = NULL, distance = "Euclidean")
}
\arguments{
\item{data}{A numeric matrix where columns correspond to data points and rows correspond to dimensions.}

\item{centers}{A numeric matrix containing coordinates for cluster centroids, with clusters in columns and dimensions in rows.}

\item{info}{A list containing additional information for each cluster, see \code{\link{buildKmknn}} for details.}

\item{order}{An integer vector of length equal to \code{ncol(data)}, specifying the order of points in \code{x} relative to the original data matrix.}

\item{NAMES}{A character vector of sample names or \code{NULL}.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An instance of the KmknnIndex class.
}
\description{
A class to hold indexing structures for the KMKNN algorithm for exact nearest neighbor identification.
}
\details{
The KmknnIndex class holds the indexing structure required to run the KMKNN algorithm.
Users should never need to call the constructor explicitly, but should generate instances of KmknnIndex classes with \code{\link{buildKmknn}}.

Users can get values from an HnswIndex object with the usual \code{[[} syntax.
All parameters listed in the constructor can be extracted in this manner.
}
\examples{
example(buildKmknn)
out[['centers']]
out[['info']]

}
\seealso{
\code{\link{buildKmknn}}, to build the index.

\linkS4class{BiocNeighborIndex}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
