% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/set_methods.R
\name{factors_names}
\alias{factors_names}
\alias{factors_names<-}
\alias{factors_names,MOFA-method}
\alias{factors_names<-,MOFA,vector-method}
\title{factors_names: set and retrieve factor names}
\usage{
factors_names(object)

factors_names(object) <- value

\S4method{factors_names}{MOFA}(object)

\S4method{factors_names}{MOFA,vector}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{value}{a character vector of factor names}
}
\value{
character vector with the factor names
}
\description{
factors_names: set and retrieve factor names
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
factors_names(model)
}
