\name{distory-package}
\Rdversion{1.1}
\alias{distory-package}
\alias{distory}
\docType{package}
\title{Distance Between Phylogenetic Histories}
\description{
  The \pkg{distory} package provides functions for computing geodesic distances
  between phylogenetic trees, as well as functions which use this distance.
  Methods for computing Gromov delta-hyperbolicity, Markov Chain Monte Carlo
  routines in tree space, and per-position leverage for DNA sequences are
  included.
}
\details{
  A description of the algorithm used for the distance computation can
  be found in \code{\link{dist.multiPhylo}}.
}
\author{
  John Chakerian <chakj@stanford.edu> and Susan Holmes <susan@stat.stanford.edu>
}
\references{
  Chakerian, J. and Holmes, S. P. Computational Tools for Evaluating
  Phylogenetic and Heirarchical Clustering Trees. arXiv:1006.1015v1.

  Billera, L. J., Holmes, S. P., and Vogtmann, K. (2001) Geometry of the space
  of phylogenetic trees. \emph{Advances in Applied Mathematics},
  \bold{27}, 733_-767.

  Megan Owen and J. Scott Provan (2010) A fast algorithm for computing
  geodesic distances in tree space. \emph{IEEE/ACM Transactions on
  Computational Biology and Bioinformatics}, 14 Jan. 2010.
}
\keyword{package}
