% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-dbi.R
\name{src_dbi}
\alias{src_dbi}
\alias{src_mysql}
\alias{src_postgres}
\alias{src_sqlite}
\title{Source for database backends}
\usage{
src_mysql(
  dbname,
  host = NULL,
  port = 0L,
  username = "root",
  password = "",
  ...
)

src_postgres(
  dbname = NULL,
  host = NULL,
  port = NULL,
  user = NULL,
  password = NULL,
  ...
)

src_sqlite(path, create = FALSE)
}
\arguments{
\item{dbname}{Database name}

\item{host, port}{Host name and port number of database}

\item{...}{for the src, other arguments passed on to the underlying
database connector, \code{\link[DBI:dbConnect]{DBI::dbConnect()}}. For the tbl, included for
compatibility with the generic, but otherwise ignored.}

\item{user, username, password}{User name and password.

Generally, you should avoid saving username and password in your
scripts as it is easy to accidentally expose valuable credentials.
Instead, retrieve them from environment variables, or use database
specific credential scores. For example, with MySQL you can set up \code{my.cnf}
as described in \code{\link[RMySQL:MySQLDriver-class]{RMySQL::MySQL()}}.}

\item{path}{Path to SQLite database. You can use the special path
":memory:" to create a temporary in memory database.}

\item{create}{if \code{FALSE}, \code{path} must already exist. If
\code{TRUE}, will create a new SQLite3 database at \code{path} if
\code{path} does not exist and connect to the existing database if
\code{path} does exist.}
}
\value{
An S3 object with class \code{src_dbi}, \code{src_sql}, \code{src}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

These functions have been deprecated; instead please use \code{\link[=tbl]{tbl()}}
directly on an \code{DBIConnection}. See \url{https://dbplyr.tidyverse.org/} for
more details.
}
\examples{
\dontshow{if (requireNamespace("dbplyr", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
copy_to(con, mtcars)

# To retrieve a single table from a source, use `tbl()`
mtcars <- con \%>\% tbl("mtcars")
mtcars

# You can also use pass raw SQL if you want a more sophisticated query
con \%>\% tbl(sql("SELECT * FROM mtcars WHERE cyl == 8"))
\dontshow{\}) # examplesIf}
}
\keyword{internal}
