% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{fct_match}
\alias{fct_match}
\title{Test for presence of levels in a factor}
\usage{
fct_match(f, lvls)
}
\arguments{
\item{f}{A factor (or character vector).}

\item{lvls}{A character vector specifying levels to look for.}
}
\value{
A logical vector
}
\description{
Do any of \code{lvls} occur in \code{f}? Compared to \link{\%in\%}, this function validates
\code{lvls} to ensure that they're actually present in \code{f}. In other words,
\code{x \%in\% "not present"} will return \code{FALSE}, but \code{fct_match(x, "not present")}
will throw an error.
}
\examples{
table(fct_match(gss_cat$marital, c("Married", "Divorced")))

# Compare to \%in\%, misspelled levels throw an error
table(gss_cat$marital \%in\% c("Maried", "Davorced"))
\dontrun{
table(fct_match(gss_cat$marital, c("Maried", "Davorced")))
}

}
