% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitRoot.R
\name{nsdiffs}
\alias{nsdiffs}
\title{Number of differences required for a seasonally stationary series}
\usage{
nsdiffs(
  x,
  alpha = 0.05,
  m = frequency(x),
  test = c("seas", "ocsb", "hegy", "ch"),
  max.D = 1,
  ...
)
}
\arguments{
\item{x}{A univariate time series}

\item{alpha}{Level of the test, possible values range from 0.01 to 0.1.}

\item{m}{Deprecated. Length of seasonal period}

\item{test}{Type of unit root test to use}

\item{max.D}{Maximum number of seasonal differences allowed}

\item{...}{Additional arguments to be passed on to the unit root test}
}
\value{
An integer indicating the number of differences required for stationarity.
}
\description{
Functions to estimate the number of differences required to make a given
time series stationary. \code{nsdiffs} estimates the number of seasonal differences
necessary.
}
\details{
\code{nsdiffs} uses seasonal unit root tests to determine the number of
seasonal differences required for time series \code{x} to be made stationary
(possibly with some lag-one differencing as well).

Several different tests are available:
\itemize{
\item If \code{test="seas"} (default), a measure of seasonal strength is used, where differencing is
selected if the seasonal strength (Wang, Smith & Hyndman, 2006) exceeds 0.64
(based on minimizing MASE when forecasting using auto.arima on M3 and M4 data).
\item If \code{test="ch"}, the Canova-Hansen (1995) test is used
(with null hypothesis of deterministic seasonality)
\item If \code{test="hegy"}, the Hylleberg, Engle, Granger & Yoo (1990) test is used.
\item If \code{test="ocsb"}, the Osborn-Chui-Smith-Birchenhall
(1988) test is used (with null hypothesis that a seasonal unit root exists).
}
}
\examples{
nsdiffs(AirPassengers)

}
\references{
Wang, X, Smith, KA, Hyndman, RJ (2006) "Characteristic-based clustering
for time series data", \emph{Data Mining and Knowledge Discovery},
\bold{13}(3), 335-364.

Osborn DR, Chui APL, Smith J, and Birchenhall CR (1988) "Seasonality and the
order of integration for consumption", \emph{Oxford Bulletin of Economics
and Statistics} \bold{50}(4):361-377.

Canova F and Hansen BE (1995) "Are Seasonal Patterns Constant
over Time? A Test for Seasonal Stability", \emph{Journal of Business and
Economic Statistics} \bold{13}(3):237-252.

Hylleberg S, Engle R, Granger C and Yoo B (1990) "Seasonal integration
and cointegration.", \emph{Journal of Econometrics} \bold{44}(1), pp. 215-238.
}
\seealso{
\code{\link{auto.arima}}, \code{\link{ndiffs}}, \code{\link{ocsb.test}}, \code{\link[uroot]{hegy.test}}, and \code{\link[uroot]{ch.test}}
}
\author{
Rob J Hyndman, Slava Razbash and Mitchell O'Hara-Wild
}
