% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstitute.R
\name{pd_reconstitute}
\alias{pd_reconstitute}
\title{Reconstitute Expressions}
\usage{
pd_reconstitute(id, pd, .check = TRUE)
}
\arguments{
\item{id}{id of the expression of interest}

\item{pd}{The \code{\link{parse-data}} information}

\item{.check}{Perform checks for input validation?}
}
\description{
Creates expressions and calls from the given
\code{id} and parse-data, \code{pd}.
}
\examples{
# load example file and get_parse data
ex.file <- system.file("examples", "example.R", package="parsetools")
exprs <- parse(ex.file, keep.source = TRUE)
pd <- get_parse_data(exprs)

# There are 3 expressions so there should be three roots.
sum(pd_is_root(pd$id, pd))
roots <- pd_all_root_ids(pd)

pd_reconstitute(roots[1], pd)
}
