% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networx.R, R/splits.R
\name{allSplits}
\alias{allSplits}
\alias{allCircularSplits}
\alias{as.splits}
\alias{splits}
\alias{as.Matrix}
\alias{distinct.splits}
\alias{as.phylo.splits}
\alias{addTrivialSplits}
\alias{removeTrivialSplits}
\alias{matchSplits}
\alias{as.matrix.splits}
\alias{as.Matrix.splits}
\alias{print.splits}
\alias{c.splits}
\alias{unique.splits}
\alias{as.splits.phylo}
\alias{as.splits.multiPhylo}
\alias{as.splits.networx}
\alias{as.prop.part.splits}
\alias{as.bitsplits.splits}
\alias{as.splits.bitsplits}
\alias{compatible}
\title{Splits representation of graphs and trees.}
\usage{
allSplits(k, labels = NULL)

allCircularSplits(k, labels = NULL)

as.splits(x, ...)

\method{as.matrix}{splits}(x, zero.print = 0L, one.print = 1L, ...)

\method{as.Matrix}{splits}(x, ...)

\method{print}{splits}(x, maxp = getOption("max.print"), zero.print = ".",
  one.print = "|", ...)

\method{c}{splits}(..., recursive = FALSE)

\method{unique}{splits}(x, incomparables = FALSE, unrooted = TRUE, ...)

\method{as.splits}{phylo}(x, ...)

\method{as.splits}{multiPhylo}(x, ...)

\method{as.splits}{networx}(x, ...)

\method{as.prop.part}{splits}(x, ...)

\method{as.bitsplits}{splits}(x)

\method{as.splits}{bitsplits}(x, ...)

compatible(obj1, obj2 = NULL)
}
\arguments{
\item{k}{number of taxa.}

\item{labels}{names of taxa.}

\item{x}{An object of class phylo or multiPhylo.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{zero.print}{character which should be printed for zeros.}

\item{one.print}{character which should be printed for ones.}

\item{maxp}{integer, default from \code{options(max.print)}, influences how
many entries of large matrices are printed at all.}

\item{recursive}{logical. If recursive = TRUE, the function recursively
descends through lists (and pairlists) combining all their elements into a
vector.}

\item{incomparables}{only for compatibility so far.}

\item{unrooted}{todo.}

\item{obj1, obj2}{an object of class splits.}
}
\value{
\code{as.splits} returns an object of class splits, which is mainly
a list of splits and some attributes. Often a \code{splits} object will
contain attributes \code{confidences} for bootstrap or Bayesian support
values and \code{weight} storing edge weights.
\code{compatible} return a lower triangular matrix where an 1 indicates that
two splits are incompatible.
}
\description{
\code{as.splits} produces a list of splits or bipartitions.
}
\note{
The internal representation is likely to change.
}
\examples{

(sp <- as.splits(rtree(5)))
write.nexus.splits(sp)
spl <- allCircularSplits(5)
plot(as.networx(spl))

}
\seealso{
\code{\link[ape]{prop.part}}, \code{\link{lento}},
\code{\link{as.networx}}, \code{\link{distanceHadamard}},
\code{\link{read.nexus.splits}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
