% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws.R
\name{draws}
\alias{draws}
\alias{as_draws}
\alias{is_draws}
\title{Transform to \code{draws} objects}
\usage{
as_draws(x, ...)

is_draws(x)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
If possible, a \code{draws} object in the closest supported format to \code{x}.
The formats are linked to in the \strong{See Also} section below.
}
\description{
Try to transform an \R object to a format supported by the \pkg{posterior}
package.
}
\details{
The class \code{"draws"} is the parent class of all supported formats,
which also have their own subclasses of the form \code{"draws_{format}"} (e.g.
\code{"draws_array"}).
}
\examples{
# create some random draws
x <- matrix(rnorm(30), nrow = 10)
colnames(x) <- c("a", "b", "c")
str(x)

# transform to a draws object
y <- as_draws(x)
str(y)

# remove the draws classes from the object
class(y) <- class(y)[-(1:2)]
str(y)

}
\seealso{
Other formats: 
\code{\link{draws_array}()},
\code{\link{draws_df}()},
\code{\link{draws_list}()},
\code{\link{draws_matrix}()},
\code{\link{draws_rvars}()}
}
\concept{formats}
