% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnsw.R
\name{hnsw_knn}
\alias{hnsw_knn}
\title{Find Nearest Neighbors and Distances}
\usage{
hnsw_knn(
  X,
  k = 10,
  distance = "euclidean",
  M = 16,
  ef_construction = 200,
  ef = 10,
  verbose = FALSE,
  progress = "bar",
  n_threads = 0,
  grain_size = 1,
  byrow = TRUE
)
}
\arguments{
\item{X}{A numeric matrix of \code{n} items to search for neighbors. If
\code{byrow = TRUE} (the default) then each row of \code{X} stores an item to be
searched. Otherwise, each item should be stored in the columns of \code{X}.}

\item{k}{Number of neighbors to return.}

\item{distance}{Type of distance to calculate. One of:
\itemize{
\item \code{"l2"} Squared L2, i.e. squared Euclidean.
\item \code{"euclidean"} Euclidean.
\item \code{"cosine"} Cosine.
\item \code{"ip"} Inner product: 1 - sum(ai * bi), i.e. the cosine distance
where the vectors are not normalized. This can lead to negative distances
and other non-metric behavior.
}}

\item{M}{Controls the number of bi-directional links created for each element
during index construction. Higher values lead to better results at the
expense of memory consumption. Typical values are \code{2 - 100}, but
for most datasets a range of \code{12 - 48} is suitable. Can't be smaller
than 2.}

\item{ef_construction}{Size of the dynamic list used during construction.
A larger value means a better quality index, but increases build time.
Should be an integer value between 1 and the size of the dataset.}

\item{ef}{Size of the dynamic list used during search. Higher values lead
to improved recall at the expense of longer search time. Can take values
between \code{k} and the size of the dataset and may be greater or smaller
than \code{ef_construction}. Typical values are \code{100 - 2000}.}

\item{verbose}{If \code{TRUE}, log messages to the console.}

\item{progress}{defunct and has no effect.}

\item{n_threads}{Maximum number of threads to use. The exact number is
determined by \code{grain_size}.}

\item{grain_size}{Minimum amount of work to do (rows in \code{X} to add or
search for) per thread. If the number of rows in \code{X} isn't sufficient,
then fewer than \code{n_threads} will be used. This is useful in cases
where the overhead of context switching with too many threads outweighs
the gains due to parallelism.}

\item{byrow}{if \code{TRUE} (the default), this indicates that the items to be
processed in \code{X} are stored in each row of \code{X}. Otherwise, the items are
stored in the columns of \code{X}. Storing items in each column reduces the
overhead of copying data to a form that can be used by the \code{hnsw}
library. Note that if \code{byrow = FALSE}, any matrices returned from this
function will also store the items by column.}
}
\value{
a list containing:
\itemize{
\item \code{idx} a matrix containing the nearest neighbor indices.
\item \code{dist} a matrix containing the nearest neighbor distances.
}

The dimensions of the matrices respect the storage (row or column-based) of
\code{X} as indicated by the \code{byrow} parameter. If \code{byrow = TRUE} (the default)
each row of \code{idx} and \code{dist} contain the neighbor information for the item
passed in the equivalent row of \code{X}, i.e. the dimensions are \verb{n x k} where
\code{n} is the number of items in \code{X}. If \code{byrow = FALSE}, then each column of
\code{idx} and \code{dist} contain the neighbor  information for the item passed in
the equivalent column of \code{X}, i.e. the dimensions are \verb{k x n}.

Every item in the dataset is considered to be a neighbor of itself, so the
first neighbor of item \code{i} should always be \code{i} itself. If that isn't the
case, then any of \code{M}, \code{ef_construction} or \code{ef} may need increasing.
}
\description{
A k-nearest neighbor algorithm using the hnswlib library
(\url{https://github.com/nmslib/hnswlib}).
}
\section{Hnswlib Parameters}{


Some details on the parameters used for index construction and search, based
on \url{https://github.com/nmslib/hnswlib/blob/master/ALGO_PARAMS.md}:
\itemize{
\item \code{M} Controls the number of bi-directional links created for each
element during index construction. Higher values lead to better results at
the expense of memory consumption, which is around \code{M * 8-10} bytes
per bytes per stored element. High intrinsic dimensionalities will require
higher values of \code{M}. A range of \code{2 - 100} is typical, but
\code{12 - 48} is ok for most use cases.
\item \code{ef_construction} Size of the dynamic list used during
construction. A larger value means a better quality index, but increases
build time. Should be an integer value between 1 and the size of the
dataset. A typical range is \code{100 - 2000}. Beyond a certain point,
increasing \code{ef_construction} has no effect. A sufficient value of
\code{ef_construction} can be determined by searching with \code{ef = ef_construction}, and ensuring that the recall is at least 0.9.
\item \code{ef} Size of the dynamic list used during index search. Can
differ from \code{ef_construction} and be any value between \code{k} (the
number of neighbors sought) and the number of elements in the index being
searched.
}
}

\examples{
iris_nn_data <- hnsw_knn(as.matrix(iris[, -5]), k = 10)
}
\references{
Malkov, Y. A., & Yashunin, D. A. (2016).
Efficient and robust approximate nearest neighbor search using Hierarchical
Navigable Small World graphs.
\emph{arXiv preprint} \emph{arXiv:1603.09320}.
}
