

#' Data for Fitting Correlated Effects Model
#' 
#' Fictional data used in TannerTanner-Smith and Tipton (2013).
#' 
#' 
#' @name corrdat
#' @docType data
#' @format A dataframe containing 172 effect sizes from 39 studies used in
#' Tanner- Smith and Tipton (2013).
#' @references Tanner-Smith E.E., Tipton, E. (2013) Robust variance estimation
#' with dependent effect sizes: practical considerations including a software
#' tutorial in Stata and SPSS. \emph{Research Synthesis Methods}. ISSN
#' 1759-2887.
#' @source https://my.vanderbilt.edu/emilytannersmith/training-materials/
#' @keywords datasets
NULL





#' Data for Fitting Correlated Effects Model With Small-Sample Corrections
#' 
#' Data used in Tipton (2013).
#' 
#' 
#' @name corrdat.sm
#' @docType data
#' @format A dataframe containing 300 effect sizes from 28 studies used in
#' Tipton (2013).
#' @references Tipton, E. (in press) Small sample adjustments for robust
#' variance estimation with meta-regression. \emph{Psychological Methods}.
#' @source Elizabeth Tipton
#' @keywords datasets
NULL





#' hedgesdat
#' 
#' Data from a meta-analysis on the effectiveness of phonics reading
#' instruction by Ehri, Nunes, Stahl and Willows (2001). Data reported in
#' Hedges, Tipton, and Johnson (2010) with example.
#' 
#' 
#' @name hedgesdat
#' @docType data
#' @format A dataframe containing 179 effect sizes from 66 different studies
#' @references
#' 
#' Ehri, L.C., Nunes, S.R., Stahl, S.A., Willows, D.M. (2001) Systematic
#' phonics instruction helps children learn to read: Evidence from the National
#' Reading Panel's meta-analysis. \emph{Review of Educational Research}.
#' \bold{71}, 393--447.
#' 
#' Hedges, L.V., Tipton, E., Johnson, M.C. (2010) Robust variance estimation in
#' meta-regression with dependent effect size estimates. \emph{Research
#' Synthesis Methods}. \bold{1}(1): 39--65. Erratum in \bold{1}(2): 164--165.
#' DOI: 10.1002/jrsm.5
#' @source Hedges, Tipton, and Johnson (2010)
#' @keywords datasets
NULL





#' Data for Fitting Hierarchical Effects Model
#' 
#' Fictional data used in TannerTanner-Smith and Tipton (2013).
#' 
#' 
#' @name hierdat
#' @docType data
#' @format A dataframe containing 68 effect sizes from 15 studies used in
#' Tanner- Smith and Tipton (2013).
#' @references Tanner-Smith E.E., Tipton, E. (2013) Robust variance estimation
#' with dependent effect sizes: practical considerations including a software
#' tutorial in Stata and SPSS. \emph{Research Synthesis Methods}. ISSN
#' 1759-2887.
#' @source https://my.vanderbilt.edu/emilytannersmith/training-materials/
#' @keywords datasets
NULL





#' IAT Criterion-Related Correlations
#' 
#' Data from a meta-analysis on IAT conducted by Oswald et al., (2013)
#' examining the predictive validity of the Implicit Association Test (IAT) and
#' various explicit measures of bias for a variety of criterion measures of
#' discrimination. Included in the dataset are the study-level correlations
#' between IAT scores and criterion measures of neurological activity or
#' response latency from the original \code{oswald2013} dataset.
#' 
#' 
#' @name oswald2013.ex1
#' @docType data
#' @format A dataframe containing 32 effect sizes from 9 studies.
#' 
#' \tabular{rlll}{ [,1] \tab Study \tab Factor \cr [,2] \tab Crit.Domain \tab
#' Factor \cr [,3] \tab IAT.ID \tab Integer \cr [,4] \tab IAT.Focus \tab Factor
#' \cr [,5] \tab Crit.ID \tab Integer \cr [,6] \tab Crit.Cat \tab Factor \cr
#' [,7] \tab Scoring \tab Factor \cr [,8] \tab Target \tab Factor \cr [,9] \tab
#' Type \tab Factor \cr [,10] \tab Sample.ID \tab Integer \cr [,11] \tab N \tab
#' Integer \cr [,12] \tab R \tab Numeric \cr [,13] \tab effect.size \tab
#' Numeric \cr [,14] \tab var.eff.size \tab Numeric }
#' @references Oswald FL, Mitchell G, Blanton H, Jaccard J, Tetlock PE (2013)
#' Predicting ethnic and racial discrimination: a meta-analysis of IAT
#' criterion studies. \emph{Journal of Personality and Social Psychology},
#' 105(2), 171-192. ISSN 1939-1315. doi:10.1037/a0032734. PMID: 23773046.
#' @source Oswald FL, Mitchell G, Blanton H, Jaccard J, Tetlock PE (2013)
#' Predicting ethnic and racial discrimination: a meta-analysis of IAT
#' criterion studies. \emph{Journal of Personality and Social Psychology},
#' 105(2), 171-192. ISSN 1939-1315. doi:10.1037/a0032734. PMID: 23773046.
#' @keywords datasets
NULL





#' IAT Criterion-Related Correlations
#' 
#' Data from a meta-analysis on IAT conducted by Oswald et al., (2013)
#' examining the predictive validity of the Implicit Association Test (IAT) and
#' various explicit measures of bias for a variety of criterion measures of
#' discrimination. Included in the dataset are the study level correlations
#' between IAT scores and some criterion measure of discrimination.
#' 
#' 
#' @name oswald2013
#' @docType data
#' @format A dataframe containing 308 effect sizes from 46 studies.
#' 
#' \tabular{rlll}{ [,1] \tab Study \tab Factor \cr [,2] \tab Crit.Domain \tab
#' Factor \cr [,3] \tab IAT.ID \tab Integer \cr [,4] \tab IAT.Focus \tab Factor
#' \cr [,5] \tab Crit.ID \tab Integer \cr [,6] \tab Crit.Cat \tab Factor \cr
#' [,7] \tab Scoring \tab Factor \cr [,8] \tab Target \tab Factor \cr [,9] \tab
#' Type \tab Factor \cr [,10] \tab Sample.ID \tab Integer \cr [,11] \tab N \tab
#' Integer \cr [,12] \tab R \tab Numeric }
#' @references Oswald FL, Mitchell G, Blanton H, Jaccard J, Tetlock PE (2013)
#' Predicting ethnic and racial discrimination: a meta-analysis of IAT
#' criterion studies. \emph{Journal of Personality and Social Psychology},
#' 105(2), 171-192. ISSN 1939-1315. doi:10.1037/a0032734. PMID: 23773046.
#' @source Oswald FL, Mitchell G, Blanton H, Jaccard J, Tetlock PE (2013)
#' Predicting ethnic and racial discrimination: a meta-analysis of IAT
#' criterion studies. \emph{Journal of Personality and Social Psychology},
#' 105(2), 171-192. ISSN 1939-1315. doi:10.1037/a0032734. PMID: 23773046.
#' @keywords datasets
NULL



