% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbiplot.R
\name{ggbiplot}
\alias{ggbiplot}
\title{Biplot for \code{\link[rsvd]{rpca}} using \code{\link[ggplot2]{ggplot}}.}
\usage{
ggbiplot(
  rpcaObj,
  pcs = c(1, 2),
  loadings = TRUE,
  groups = NULL,
  alpha = 0.6,
  ellipse = TRUE,
  alpha.ellipse = 0.2,
  var_labels = TRUE,
  var_labels.names = NULL,
  ind_labels = TRUE,
  ind_labels.names = NULL
)
}
\arguments{
\item{rpcaObj}{Object returned by the \code{\link[rsvd]{rpca}} function.}

\item{pcs}{Array_like. \cr
An array with two values indicating the two PCs which should be used for plotting. 
By default the first two PCs are used, e.g., \eqn{c(1,2)}.}

\item{loadings}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
If \eqn{TRUE}, the eigenvectors
are unit scaled by the square root of the eigenvalues \eqn{W = W * diag(sqrt(eigvals))}.}

\item{groups}{Factor, optional. \cr
Factor indicating groups.}

\item{alpha}{Scalar, optional. \cr
Alpha transparency for scatter plot.}

\item{ellipse}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
Draw a 1sd data ellipse for each group, if \eqn{TRUE}.}

\item{alpha.ellipse}{Scalar, optional. \cr
Alpha transparency for ellipse.}

\item{var_labels}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
Plot variable names, if \eqn{TRUE}.}

\item{var_labels.names}{Array_like, optional. \cr
User specific labels for the individuals.}

\item{ind_labels}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
Plot data point names, if \eqn{TRUE}.}

\item{ind_labels.names}{Array_like, optional. \cr
User specific labels for data points.}
}
\description{
Creates a pretty biplot which is showing the individual factor map overlayed by the
variables factor map, i.e, plotting both the principal component scores and directions.
}
\examples{
#See ?rpca
}
\seealso{
\code{\link[rsvd]{rpca}}, \code{\link[ggplot2]{ggplot}}
}
\author{
N. Benjamin Erichson, \email{erichson@berkeley.edu}
}
