% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_labels.R
\name{copy_labels}
\alias{copy_labels}
\title{Copy value and variable labels to (subsetted) data frames}
\usage{
copy_labels(df_new, df_origin = NULL, ...)
}
\arguments{
\item{df_new}{The new, subsetted data frame.}

\item{df_origin}{The original data frame where the subset (\code{df_new}) stems from;
use \code{NULL}, if value and variable labels from \code{df_new} should be removed.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples'.}
}
\value{
Returns \code{df_new} with either removed value and variable label attributes
          (if \code{df_origin = NULL}) or with copied value and variable label
          attributes (if \code{df_origin} was the original subsetted data frame).
}
\description{
Subsetting-functions usually drop value and variable labels from
               subsetted data frames (if the original data frame has value and variable
               label attributes). This function copies these value and variable
               labels back to subsetted data frames that have been subsetted, for instance,
               with \code{\link{subset}}.
}
\note{
In case \code{df_origin = NULL}, all possible label attributes
        from \code{df_new} are removed.
}
\examples{
library(dplyr)
data(efc)

# create subset - drops label attributes
efc.sub <- subset(efc, subset = e16sex == 1, select = c(4:8))
str(efc.sub)

# copy back attributes from original dataframe
efc.sub <- copy_labels(efc.sub, efc)
str(efc.sub)

# remove all labels
efc.sub <- copy_labels(efc.sub)
str(efc.sub)

# create subset - drops label attributes
efc.sub <- subset(efc, subset = e16sex == 1, select = c(4:8))
# create subset with dplyr's select - attributes are preserved
efc.sub2 <- select(efc, c160age, e42dep, neg_c_7, c82cop1, c84cop3)

# copy labels from those columns that are available
copy_labels(efc.sub, efc.sub2) \%>\% str()

# copy labels from only some columns
copy_labels(efc.sub, efc, e42dep) \%>\% str()
copy_labels(efc.sub, efc, -e17age) \%>\% str()


}
