% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coffee_data.R
\docType{data}
\name{coffee_data}
\alias{coffee_data}
\title{World coffee production data}
\format{
A data frame (tibble) with 58 for the following 12 variables:
\itemize{
\item{name_long} {name of country or coffee variety}
\item{coffee_production_2016} {production in 2016}
\item{coffee_production_2017} {production in 2017}
}
}
\source{
The International Coffee Organization (ICO). See http://www.ico.org/ and
http://www.ico.org/prices/m1-exports.pdf
}
\usage{
coffee_data
}
\description{
A tiny dataset containing estimates of global coffee in thousands of 60 kg bags produced by country.
Purpose: teaching **not** research.
}
\details{
The examples section shows how this can be joined with spatial data to create a simple map.
}
\examples{
head(coffee_data)
\dontrun{
library(tidyverse)
library(sf)
# found by searching for "global coffee data"
u = "http://www.ico.org/prices/m1-exports.pdf"
download.file(u, "data.pdf", mode = "wb")
install.packages("pdftables") # requires api key
pdftables::convert_pdf(input_file = "data.pdf", output_file = "coffee-data-messy.csv")
d = read_csv("coffee-data-messy.csv")
file.remove("coffee-data-messy.csv")
file.remove("data.pdf")
coffee_data = slice(d, -c(1:9)) \%>\% 
        select(name_long = 1, coffee_production_2016 = 2, coffee_production_2017 = 3) \%>\% 
        filter(!is.na(coffee_production_2016)) \%>\% 
        mutate_at(2:3, str_replace, " ", "") \%>\% 
        mutate_at(2:3, as.integer)
world_coffee = left_join(world, coffee_data)
plot(world_coffee[c("coffee_production_2016", "coffee_production_2017")])
b = c(0, 500, 1000, 2000, 3000)
library(tmap)
tm_shape(world_coffee) +
  tm_fill("coffee_production_2017", title = "Thousand 60kg bags", breaks = b,
          textNA = "No data", colorNA = NULL)
tmap_mode("view") # for an interactive version
}
}
\keyword{datasets}
\keyword{misc}
