% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.utils.R
\name{ssolve}
\alias{ssolve}
\alias{sginv}
\alias{srcond}
\alias{snearPD}
\alias{xTAx_ssolve}
\alias{xTAx_qrssolve}
\alias{sandwich_ssolve}
\title{Wrappers around matrix algebra functions that pre-\emph{s}cale their
arguments}
\usage{
ssolve(a, b, ..., snnd = TRUE)

sginv(X, ..., snnd = TRUE)

srcond(x, ..., snnd = TRUE)

snearPD(x, ...)

xTAx_ssolve(x, A, ...)

xTAx_qrssolve(x, A, tol = 1e-07, ...)

sandwich_ssolve(A, B, ...)
}
\arguments{
\item{snnd}{assume that the matrix is symmetric non-negative
definite (SNND). If it's "obvious" that it's not (e.g., negative
diagonal elements), an error is raised.}

\item{x, a, b, X, A, B, tol, ...}{corresponding arguments of the wrapped functions.}
}
\description{
Covariance matrices of variables with very different orders of
magnitude can have very large ratios between their greatest and
their least eigenvalues, causing them to appear to the algorithms
to be near-singular when they are actually very much SPD. These
functions first scale the matrix's rows and/or columns by its
diagonal elements and then undo the scaling on the result.
}
\details{
\code{ssolve()}, \code{sginv()}, and \code{snearPD()} wrap \code{\link[=solve]{solve()}},
\code{\link[MASS:ginv]{MASS::ginv()}}, and \code{\link[Matrix:nearPD]{Matrix::nearPD()}}, respectively. \code{srcond()}
returns the reciprocal condition number of \code{\link[=rcond]{rcond()}} net of the
above scaling. \code{xTAx_ssolve}, \code{xTAx_qrssolve}, and
\code{sandwich_ssolve} wrap the corresponding \pkg{statnet.common}
functions.
}
\examples{
x <- rnorm(2, sd=c(1,1e12))
x <- c(x, sum(x))
A <- matrix(c(1, 0, 1,
              0, 1e24, 1e24,
              1, 1e24, 1e24), 3, 3)
stopifnot(all.equal(
  xTAx_qrssolve(x,A),
  structure(drop(x\%*\%sginv(A)\%*\%x), rank = 2L, nullity = 1L)
))

x <- rnorm(2, sd=c(1,1e12))
x <- c(x, rnorm(1, sd=1e12))
A <- matrix(c(1, 0, 1,
              0, 1e24, 1e24,
              1, 1e24, 1e24), 3, 3)

stopifnot(try(xTAx_qrssolve(x,A), silent=TRUE) ==
  "Error in xTAx_qrssolve(x, A) : x is not in the span of A\n")

}
