% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat-ui.R
\name{expect_doppelganger}
\alias{expect_doppelganger}
\title{Does a figure look like its expected output?}
\usage{
expect_doppelganger(title, fig, path = NULL, ..., verbose = NULL,
  writer = write_svg)
}
\arguments{
\item{title}{A brief description of what is being tested in the
figure. For instance: "Points and lines overlap".

If a ggplot2 figure doesn't have a title already, \code{title} is
applied to the figure with \code{ggtitle()}.

The title is also used as file name for storing SVG (in a
sanitzed form, with special characters converted to \code{"-"}).}

\item{fig}{A figure to test. This can be a ggplot object, a
recordedplot, or more generally any object with a \code{print} method.

For plots that can't be represented as printable objects, you can
pass a function. This function must construct the plot and print
it.}

\item{path}{The path where the test case should be stored, relative
to the \code{tests/figs/} folder. If \code{NULL} (the default), the current
testthat context is used to create a subfolder. Supply an empty
string \code{""} if you want the figures to be stored in the root
folder.}

\item{...}{Additional arguments passed to \code{\link[testthat:compare]{testthat::compare()}} to
control specifics of comparison.}

\item{verbose}{Soft-deprecated. See the debugging section.}

\item{writer}{A function that takes the plot, a target SVG file,
and an optional plot title. It should transform the plot to SVG
in a deterministic way and write it to the target file. See
\code{\link[=write_svg]{write_svg()}} (the default) for an example.}
}
\description{
\code{expect_doppelganger()} takes a figure to check visually.
\itemize{
\item If the figure has yet to be validated, the test is skipped. Call
\code{\link[=manage_cases]{manage_cases()}} to validate the new figure, so vdiffr knows what
to compare against.
\item If the test has been validated, \code{fig} is compared to the
validated figure. If the plot differs, a failure is issued
(except on CRAN, see section on regression testing below).

Either fix the problem, or call \code{\link[=manage_cases]{manage_cases()}} to validate the
new figure appearance.
}
}
\section{Regression testing versus Unit testing}{


Failures to match a validated appearance are only reported when the
tests are run locally, on Travis, Appveyor, or any environment
where the \code{Sys.getenv("CI")} or \code{Sys.getenv("NOT_CRAN")} variables
are set. Because vdiffr is more of a monitoring than a unit testing
tool, it shouldn't cause R CMD check failures on the CRAN machines.

Checking the appearance of a figure is inherently fragile. It is
similar to testing for errors by matching exact error messages:
these messages are susceptible to change at any time. Similarly,
the appearance of plots depends on a lot of upstream code, such as
the way margins and spacing are computed. vdiffr uses a special
ggplot2 theme that should change very rarely, but there are just
too many upstream factors that could cause breakages. For this
reason, figure mismatches are not necessarily representative of
actual failures.

Visual testing is not an alternative to writing unit tests for the
internal data transformations performed during the creation of your
figure. It is more of a monitoring tool that allows you to quickly
check how the appearance of your figures changes over time, and to
manually assess whether changes reflect actual problems in your
package.

If you need to override the default vdiffr behaviour on CRAN (not
recommended) or Travis (for example to run the tests in a
particular builds but not others), set the \code{VDIFFR_RUN_TESTS}
environment variable to "true" or "false".
}

\section{Debugging}{


It is sometimes difficult to understand the cause of a failure.
This usually indicates that the plot is not created
deterministically. Potential culprits are:
\itemize{
\item Some of the plot components depend on random variation. Try
setting a seed.
\item The plot depends on some system library. For instance sf plots
depend on libraries like GEOS and GDAL. It might not be possible
to test these plots with vdiffr (which can still be used for
manual inspection, add a \code{\link[testthat:skip]{testthat::skip()}} before the
\code{expect_doppelganger()} call in that case).
}

To help you understand the causes of a failure, vdiffr
automatically logs the SVG diff of all failures when run under R
CMD check. The log is located in \code{tests/vdiffr.Rout.fail} and
should be displayed on Travis.

You can also set the \code{VDIFFR_LOG_PATH} environment variable with
\code{Sys.setenv()} to unconditionally (also interactively) log failures
in the file pointed by the variable.
}

\examples{
if (FALSE) {  # Not run

library("ggplot2")

test_that("plots have known output", {
  disp_hist_base <- function() hist(mtcars$disp)
  expect_doppelganger("disp-histogram-base", disp_hist_base)

  disp_hist_ggplot <- ggplot(mtcars, aes(disp)) + geom_histogram()
  expect_doppelganger("disp-histogram-ggplot", disp_hist_ggplot)
})

}
}
