//
// project a P0 field q_h in P1 space: p_h
//   print field and projected field
// re-project in P0 space
// usage:
//  demo2 square-h=0.1 | d_dx | demo_proj | demo2_error_grad
//
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

string get_primitive_approx (const space &Th)
{
    string Pk1 = Th.get_approx();
    if (Pk1 == "P1d") return "P2";
    if (Pk1 == "P0")  return "P1";
    cerr << "unexpected approximation " << Pk1 << endl;
    exit (1);
}

int main(int argc, char**argv)
{
    field qh;
    cin >> qh;
    int digits10 = numeric_limits<Float>::digits10;
    cout << setprecision(digits10) << qh;

    // project P(k-1) discontinuous gradient in Pk continuous
    space Th = qh.get_space();
    string Pk = get_primitive_approx(Th);
    space Vh (Th.get_geo(), Pk);
    form proj (Th, Vh, "mass");
    form mv   (Vh, Vh, "mass");
    ssk<Float> fact_mv = ldlt(mv.uu);
    field ph (Vh);
    ph.u = fact_mv.solve(proj.uu*qh.u);

    // re-project in P0 and output
    form inv_mt(Th, Th, "inv_mass");
    // TODO: use: field ph0 = inv_mv*proj.trans_mult(ph)
    field ph0(Th);
    ph0.u = inv_mt.uu*(proj.uu.trans_mult(ph.u));

    cout << setprecision(digits10) << ph0;
    return 0;
}
