#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main (int argc, char** argv) {
  environment rheolef (argc, argv);
  field uh;
  din >> uh;
  const space& Xh = uh.get_space();
  size_t d = uh.get_geo().dimension();
  string valued = (d == 3) ? "vector" : "scalar";
  space Ph (uh.get_geo(), "P2", valued);
  Ph.block("top");  Ph.block("bottom");
  if (d == 3) {
    Ph.block("back"); Ph.block("front");
  } else {
    Ph.block("left"); Ph.block("right");
  }
  trial u (Xh), psi (Ph); test phi (Ph);
  form a = (d == 3) ? integrate (ddot(grad(psi),grad(phi)))
                    : integrate ( dot(grad(psi),grad(phi)));
  form b = (d==3) ? integrate (dot(curl(u),phi))
                  : integrate (curl(u)*phi);
  field psi_h (Ph, 0.);
  field lh = b*uh;
  solver sa (a.uu());
  psi_h.set_u() = sa.solve (lh.u() - a.ub()*psi_h.b());
  dout << catchmark("psi") << psi_h;
}
