% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.plugin-functions.R
\name{rk.assign.preview.data}
\alias{.rk.discard.preview.data}
\alias{rk.assign.preview.data}
\alias{rk.discard.preview.data}
\alias{rk.get.preview.data}
\title{Manage (shortly) persistent data for previews (for use in RKWard plugins wishing to provide custom previews)}
\usage{
rk.assign.preview.data(id, value = list())

rk.get.preview.data(id)

rk.discard.preview.data(id)
}
\arguments{
\item{id}{(character). Id associated with the data. Usually this will be the 'id' value of the <preview>-box.}

\item{value.}{The value to assign. If this is a list, and contains a function named "on.delete", this function
will be run by rk.discard.preview.data (with the \code{id} as argument. This is useful for running custom clearnup
code, such as removing temporary files, etc.}
}
\value{
\code{rk.assign.preview.data} amd \code{rk.get.preview.data} returns the preview data (newly) associated
   with the given id. \code{rk.discard.preview.data} returns \code{NULL}, invisibly.

\bold{Note}: Plugins that want to produce a single plot, or open a single object via \code{\link{rk.edit}()} do \bold{not}
             have to call these functions, manually. See the chapter on providing previews in the Introduction to
             writing plugins for RKWard.
}
\description{
\code{rk.assign.preview.data} stores data associated with a specific "id". Usually this id is
   provided by the <preview>-feature of a plugin.
\code{rk.get.preview.data} retrieves data previously stored with \code{rk.assign.preview.data}
\code{rk.discard.preview.data} discards data previously stored with \code{rk.assign.preview.data}.
   This gets called by the <preview>-box of the plugin, automtically, when the plugin dialog is closed.
   You do not generally have to call it manually. See the notes for running custom clearnup code, below.
}
\examples{
## To be generated in the preview() code section of a plugin

## NOT RUN
pdata &lt;- rk.get.preview.data("SOMEID")
if (is.null (pdata)) {
  outfile &lt;- rk.get.tempfile.name(prefix="preview", extension=".txt")
  pdata &lt;- list(filename=outfile, on.delete=function (id) {
    unlink(rk.get.preview.data(id)$filename)
  })
  rk.assign.preview.data("SOMEID", pdata)
}
try ({
  cat ("This is a test", pdata$filename)
  rk.edit.files(file=pdata$filename)
})
## END NOT RUN

}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{utilities}

