% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_graphics.R
\name{RK.addHook}
\alias{RK.addHook}
\alias{RK.removeHook}
\alias{RK.revision}
\title{Detect changes in the RKWard native graphics device(s)}
\usage{
RK.addHook(after.create, in.close, in.blank)

RK.removeHook(handle)

RK.revision(devnum = dev.cur())
}
\arguments{
\item{after.create}{(optional argument) A function with the signature \code{function(devnum, ...)}, to be called
immediately after a new \code{RK()} device has been created. The function will be called with
the corresponding device number as the first arugment. It is recommended to add \code{...} in addition,
to remain compatible with future extensions.}

\item{in.close}{(optional argument) A function with the signature \code{function(devnum, snapshot, ...)}. Called when a device is closed.
At this point the device may or may not still be visible, but can no longer be accessed.
The function is called with two parameters: the device number, and a snapshot of the most recent
plot (as would have been produced by \code{recordPlot()}; empty, if disabled via \code{dev.control()}.}

\item{in.blank}{(optional argument) A function with the signature \code{function(devnum, snapshot, ...)}.
The given function will be Called whenever an existing device is blanked, i.e. usually, when a new plot 
is about to be drawn. While this hook is called, the old plot is still visible, but \code{recordPlot()}
/ \code{dev.copy} would return / copy a blank plot, already. You can retrieve the previous plot from the
parameter \code{snapshot}, instead (unless plot recording has been disabled via \code{dev.control()}).}

\item{devnum}{Device number}
}
\description{
\code{RK.addHook()} registers functions to be called when plot windows are created / closed / blanked.
}
\details{
\code{RK.removeHook()} removes hook functions previously registered with \code{RK.addHook()}.

\code{RK.revision()} can be used to detect changes done to an existing \code{RK()} by comparing the
                     return value of two subsequent calls: If the value has increased, the plot has been touched.

The return value of \code{RK.addHook()} may be passed to \code{RK.removeHook()} to remove the hook(s) registered
         in that call. No assumptions should be made on the exact nature of that return value (it might be subject to
         change in future versions.

         \code{RK.revision()} returns a integer number. This will be 0 for a device that has just been created. If the device
         is modified (changes need not necessarily be visible), the next call to \code{RK.revision()} will return a larger
         number. The details of how revisions are counted may be subject to change, and in particular they do not give
         any information on how much has been changed. Redraws due to resizing the plot window do not increase the revision number.
}
\examples{
\dontrun{
hook <- RK.addHook(
   after.create=function(devnum, ...) {
       print(paste0("New device ", devnum))
   },
   in.close=function(devnum, snapshot, ...) {
       print(paste0("Closed device ", devnum))
   }
)

RK() # Prints "New device N"
plot(1, 1)
rev <- RK.revision(dev.cur())
plot(2, 2) # we know this will touch the plot, but consider e.g. sourcing a script, here
if (RK.revision(dev.cur()) > rev) {
   print("Plot was modified")
}
dev.off() # Prints "Closed device N"

RK.removeHook(hook)
}

}
\seealso{
\link{RK}
}
