// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, CompletionColumn};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceCompletionCell")]
    pub struct CompletionCell(Object<ffi::GtkSourceCompletionCell, ffi::GtkSourceCompletionCellClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_source_completion_cell_get_type(),
    }
}

impl CompletionCell {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CompletionCell`] objects.
    ///
    /// This method returns an instance of [`CompletionCellBuilder`](crate::builders::CompletionCellBuilder) which can be used to create [`CompletionCell`] objects.
    pub fn builder() -> CompletionCellBuilder {
        CompletionCellBuilder::new()
    }

    #[doc(alias = "gtk_source_completion_cell_get_column")]
    #[doc(alias = "get_column")]
    pub fn column(&self) -> CompletionColumn {
        unsafe {
            from_glib(ffi::gtk_source_completion_cell_get_column(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_cell_get_widget")]
    #[doc(alias = "get_widget")]
    pub fn widget(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::gtk_source_completion_cell_get_widget(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_gicon")]
    pub fn set_gicon(&self, gicon: &impl IsA<gio::Icon>) {
        unsafe {
            ffi::gtk_source_completion_cell_set_gicon(
                self.to_glib_none().0,
                gicon.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_icon_name")]
    pub fn set_icon_name(&self, icon_name: &str) {
        unsafe {
            ffi::gtk_source_completion_cell_set_icon_name(
                self.to_glib_none().0,
                icon_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_markup")]
    #[doc(alias = "markup")]
    pub fn set_markup(&self, markup: &str) {
        unsafe {
            ffi::gtk_source_completion_cell_set_markup(
                self.to_glib_none().0,
                markup.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_paintable")]
    #[doc(alias = "paintable")]
    pub fn set_paintable(&self, paintable: &impl IsA<gdk::Paintable>) {
        unsafe {
            ffi::gtk_source_completion_cell_set_paintable(
                self.to_glib_none().0,
                paintable.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_text")]
    #[doc(alias = "text")]
    pub fn set_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_source_completion_cell_set_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_text_with_attributes")]
    pub fn set_text_with_attributes(&self, text: &str, attrs: &pango::AttrList) {
        unsafe {
            ffi::gtk_source_completion_cell_set_text_with_attributes(
                self.to_glib_none().0,
                text.to_glib_none().0,
                attrs.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_cell_set_widget")]
    #[doc(alias = "widget")]
    pub fn set_widget(&self, child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::gtk_source_completion_cell_set_widget(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    pub fn markup(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "markup")
    }

    pub fn paintable(&self) -> Option<gdk::Paintable> {
        ObjectExt::property(self, "paintable")
    }

    pub fn text(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "text")
    }

    #[doc(alias = "markup")]
    pub fn connect_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_trampoline<F: Fn(&CompletionCell) + 'static>(
            this: *mut ffi::GtkSourceCompletionCell,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_markup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "paintable")]
    pub fn connect_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paintable_trampoline<F: Fn(&CompletionCell) + 'static>(
            this: *mut ffi::GtkSourceCompletionCell,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paintable\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_paintable_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text")]
    pub fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<F: Fn(&CompletionCell) + 'static>(
            this: *mut ffi::GtkSourceCompletionCell,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "widget")]
    pub fn connect_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_widget_trampoline<F: Fn(&CompletionCell) + 'static>(
            this: *mut ffi::GtkSourceCompletionCell,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::widget\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_widget_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CompletionCell`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CompletionCellBuilder {
    builder: glib::object::ObjectBuilder<'static, CompletionCell>,
}

impl CompletionCellBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn column(self, column: CompletionColumn) -> Self {
        Self {
            builder: self.builder.property("column", column),
        }
    }

    pub fn markup(self, markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("markup", markup.into()),
        }
    }

    pub fn paintable(self, paintable: &impl IsA<gdk::Paintable>) -> Self {
        Self {
            builder: self
                .builder
                .property("paintable", paintable.clone().upcast()),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    pub fn widget(self, widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("widget", widget.clone().upcast()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CompletionCell`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CompletionCell {
        self.builder.build()
    }
}
