---
myst:
  html_meta:
    keywords: LaTeX, fichiers, tds, installer LaTeX, installer TeX Live, 
              extensions des fichiers LaTeX, formats de fichiers LaTeX
---

# Où installer les extensions ?

Nous supposons ici que vous avez décidé dans quel arbre placer vos fichiers, 
après avoir vu la question "[](/5_fichiers/emplacements/la_tds)". 
Nous l'appelerons ici `$TEXMF` et vous devrez le remplacer par l'arbre que vous avez choisi.

L'idée de base est d'imiter la structure des répertoires de votre ou vos arbres existants. 
Voici quelques exemples d'emplacement de différents types de fichiers :

| Suffixe                            | Répertoire                                  |
| ---------------------------------- | ------------------------------------------- |
| `.sty`, `.cls` ou `.fd`            | `$TEXMF/tex/⟨format⟩/⟨package⟩/`            |
| `.mf`                              | `$TEXMF/fonts/source/⟨fonderie⟩/⟨fonte⟩/`   |
| `.tfm`                             | `$TEXMF/fonts/tfm/⟨fonderie⟩/⟨fonte⟩/`      |
| `.vf`                              | `$TEXMF/fonts/vf/⟨fonderie⟩/⟨fonte⟩/`       |
| `.afm`                             | `$TEXMF/fonts/afm/⟨fonderie⟩/⟨fonte⟩/`      |
| `.pfb`                             | `$TEXMF/fonts/type1/⟨fonderie⟩/⟨fonte⟩/`    |
| `.ttf`                             | `$TEXMF/fonts/truetype/⟨fonderie⟩/⟨fonte⟩/` |
| `.otf`                             | `$TEXMF/fonts/opentype/⟨fonderie⟩/⟨fonte⟩/` |
| `.pool`, `.fmt`, `.base` ou `.mem` | `$TEXMF/web2c/`                             |

Pour les systèmes modernes, ceux distribués en 2005 ou plus tard, 
utilisant les schémas TDS v1.1, d'autres emplacements s'ajoutent :

| Suffixe | Répertoire                               |
| ------- | ---------------------------------------- |
| `.map`  | `$TEXMF/fonts/map/⟨syntaxe⟩/⟨ensemble⟩/` |
| `.enc`  | `$TEXMF/fonts/enc/⟨syntaxe⟩/⟨ensemble⟩/` |

Les fichiers de correspondances et d'encodage étaient placés 
dans des répertoires sous `$TEXMF/dvips/` dans les distributions antérieures.

Dans les listes ci-dessus, `⟨format⟩` identifie le format pour lequel les commandes sont conçues.
Il peut s'agir de choses telles que `plain`, `generic` (*i.e.*, tout format), `latex` ou `context` 
(ou d'autres formats moins courants).

Pour les polices, `⟨fonte⟩` se réfère à la famille de polices (comme `cm` 
pour *[Computer Modern](wpfr:Computer_Modern)* de Knuth, 
`times` pour [Times Roman](wpfr:Times_New_Roman) d'Adobe). 
De même, la `⟨fonderie⟩` est généralement évidente, au cas particulier près de `public`,
couramment utilisée pour les polices gratuites.

La `⟨syntaxe⟩` (pour les fichiers `map` et `enc`) est une catégorisation 
basée sur la façon dont les fichiers sont écrits. 
Les possibilités sont des noms de programmes tels que `dvips` ou `pdftex`.

Un élément associé à (La)TeX peut prendre d'autres formes que les `sty`, `cls` 
ou `fd` listées ci-dessus. Les exemples sont :
- `tex` ; 
- `lfd` pour les définitions de langage de [babel](ctanpkg:babel) ; 
- `sto` et `clo` pour les options des extensions et des classes ;
- `cfg` pour les informations de configuration ;
- `def` pour les variantes (comme les types de périphériques <ctanpkg:graphics>). 

Le fichier `README` de l'extension devrait vous indiquer s'il y en a d'autres, 
bien que parfois cette information soit imprimée uniquement 
lorsque une partie du code est décommentée 
(voir la question "[](/6_distributions/ctan/comment_trouver_un_package)").
Tous ces fichiers doivent cohabiter avec les fichiers principaux de l'extension.

Notez que `⟨fonte⟩` peut représenter une seule police ou une famille entière : 
par exemple, les fichiers pour toutes les polices *Computer Modern* de Knuth 
se trouvent dans `.../public/cm`, avec divers préfixes appropriés.

La `⟨fonderie⟩` de polices *public* est une sorte de fourre-tout 
pour les polices libres produites pour être utilisées avec (La)TeX : 
outre les polices de Knuth, le répertoire *public* contient des polices conçues 
par d'autres (à l'origine dans MetaFont, mais plus exclusivement depuis lors).

La documentation de chaque extension devrait aller, de manière indifférenciée, 
dans un répertoire de la sous-arborescence `doc/` de la TDS. 
La disposition de la sous-arborescence est légèrement différente : 
`doc/latex` héberge tous les répertoires de documentation LaTeX, 
mais les choses plus fondamentales sont couvertes, *par exemple*, 
par `doc/etex` ou `doc/xetex`.


:::{sources}
[Where to install packages](faquk:FAQ-install-where)
:::
