package Devscripts::Uscan::Templates::Pypi;

use strict;

sub transform {
    my $watchSource = shift;
    delete $watchSource->{template};
    my $dist = delete $watchSource->{dist};

    die 'Missing Dist' unless $dist;

    $watchSource->{source}          ||= "https://pypi.debian.net/$dist/";
    $watchSource->{matchingpattern} ||= "$dist" . '-@ANY_VERSION@.tar.gz';
    $watchSource->{searchmode}      ||= 'plain';
    $watchSource->{pgpmode}         ||= 'none';

    $watchSource->{versionmangle} = 's/.*-//; s/\.tar\.gz//'
      unless defined $watchSource->{versionmangle};

    return $watchSource;
}

1;
