/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PERFORMANCESPLAN__
#define __PERFORMANCESPLAN__

#include <src/global/global.h>

typedef struct performancesplan CONTENEUR(PerformancesPlan);

struct performancesplan
{
	STOCKAGE_SCALAIRE(Indice) nombreideestotal;
	//Nombres d'ides effectivement prsentes
	//dans le document produit.
	STOCKAGE_SCALAIRE(Indice) nombreideesmanquantes;
	//Nombre d'ides manquantes ajoutes par
	//l'algorithme de calcul du plan.
	STOCKAGE_SCALAIRE(Indice) nombreideesgeneralites;
	//Nombre d'ides gnriques ajoutes par
	//l'algorithme de calcul du plan.
	STOCKAGE_SCALAIRE(Indice) nombrereferencestotal;
	//Nombre de rfrences prsentes dans le
	//document final.
	STOCKAGE_SCALAIRE(Indice) nombrereferencesirreductibles;
	//Donne le nombre d'ides irrductibles
	//restantes aprs le calcul du plan.
};
/* Structure servant  recevoir des performances
 * sur le plan calcul.
 */

Resultat performancesplan_initialisation(TRAVAIL(PerformancesPlan) performancesplan);
/* Cre une structure d'enregistrement des informations
 * de performances du plan calcul.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation mmoire.
 */

Resultat performancesplan_renseignement(TRAVAIL(PerformancesPlan) performancesplan , TRAVAIL_SCALAIRE(Statistiques) statisques);
/* Renseigne les divers champs de performances du plan.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 */

Resultat performancesplan_lecture_nombreideestotal(TRAVAIL(PerformancesPlan) performancesplan , REFERENCE_SCALAIRE(Indice) nombreideestotal);
/* Renvoie le nombre d'ides total du plan calcul.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 */

Resultat performancesplan_lecture_nombreideesmanquantes(TRAVAIL(PerformancesPlan) performancesplan , REFERENCE_SCALAIRE(Indice) nombreideesmanquantes);
/* Renvoie le nombre d'ides manquantes du plan calcul.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 */

Resultat performancesplan_lecture_nombreideesgeneralites(TRAVAIL(PerformancesPlan) performancesplan , REFERENCE_SCALAIRE(Indice) nombreideesgeneralites);
/* Renvoie le nombre d'ides gnriques du plan calcul.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 */

Resultat performancesplan_lecture_nombrereferencestotal(TRAVAIL(PerformancesPlan) performancesplan , REFERENCE_SCALAIRE(Indice) nombrereferencestotal);
/* Renvoie le nombre de rfrences total du plan calcul.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 */

Resultat performancesplan_lecture_nombrereferencesirreductibles(TRAVAIL(PerformancesPlan) performancesplan , REFERENCE_SCALAIRE(Indice) nombrereferencesirreductibles);
/* Renvoie le nombre de rfrences irrductibles du plan calcul.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 */

Resultat performancesplan_copie(TRAVAIL(PerformancesPlan) performancesplan , TRAVAIL(PerformancesPlan) copie);
/* Ralise une copie des performances du plan calcul .
 * Si la copie tait non vide, elle est dtruite
 * avant la copie.
 * Renvoie RESULTAT_ERREUR si performancesplan est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat performancesplan_destruction(TRAVAIL(PerformancesPlan) performancesplan);
/* Dtruit des performances du plan calcul.
 */

#endif
