% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ReadAlleles}
\alias{ReadAlleles}
\title{Loads the variant_numth variant, and then fills acbuf with integer allele
codes, where each column of the buffer corresponds to a sample.  An allele
code of 0 corresponds to the REF allele, 1 to the first ALT, 2 to the
second ALT, etc.  Missing hardcalls are represented by a pair of NA codes.}
\usage{
ReadAlleles(pgen, acbuf, variant_num, phasepresent_buf = NULL)
}
\arguments{
\item{pgen}{Object returned by NewPgen().}

\item{acbuf}{Buffer returned by AlleleCodeBuf() or IntAlleleCodeBuf().}

\item{variant_num}{Variant index (1-based).}

\item{phasepresent_buf}{Buffer returned by BoolBuf().  Optional; if
provided, elements are set to true when the sample has known phase.  Most
of these values will be TRUE even when the raw data is unphased, because
homozygous genotypes always have known phase.  (Missing genotypes are
considered to have unknown phase.)}
}
\value{
No return value, called for acbuf-filling side-effect.
}
\description{
This function treats the data as diploid.  If it's really haploid, you may
want to compare the two rows, and then treat samples where the allele codes
differ as missing values.
}
