#!/usr/bin/env python3

from os import environ, path
from subprocess import call

import sys

prefix = environ.get('MESON_INSTALL_PREFIX', '/usr/local')
datadir = path.join(prefix, 'share')
destdir = environ.get('DESTDIR', '')
version = sys.argv[1] if len(sys.argv) == 2 else '1.0.0'

# Package managers set this so we don't need to run
if not destdir:
    print('Updating icon cache...')
    call(['gtk-update-icon-cache', '-qtf', path.join(datadir, 'icons', 'hicolor')])

    print('Updating desktop database...')
    call(['update-desktop-database', '-q', path.join(datadir, 'applications')])

    print('Compiling GSettings schemas...')
    call(['glib-compile-schemas', path.join(datadir, 'glib-2.0', 'schemas')])

# Valac doesn't set namespace headers for whatever reason, so we do it manually
s = "[CCode (cprefix = \"Marble\", gir_namespace = \"Marble\", gir_version = \"%s\", lower_case_cprefix = \"marble_\")]\n" % version

fp = path.join(destdir + datadir, 'vala', 'vapi', 'marble.vapi')

f = open(fp, 'r')
contents = f.readlines()
f.close()

contents.insert(2, s)

f = open(fp, 'w')
contents = ''.join(contents)
f.write(contents)
f.close()

print('Wrote marble.vapi header\n%s' % s)
