# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_service import LinkedService


class AmazonS3LinkedService(LinkedService):
    """Linked service for Amazon S3.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param connect_via: The integration runtime reference.
    :type connect_via:
     ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the
     linked service.
    :type annotations: list[object]
    :param type: Required. Constant filled by server.
    :type type: str
    :param access_key_id: The access key identifier of the Amazon S3 Identity
     and Access Management (IAM) user. Type: string (or Expression with
     resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Amazon S3 Identity
     and Access Management (IAM) user.
    :type secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the
     S3 Connector. This is an optional property; change it only if you want to
     try a different service endpoint or want to switch between https and http.
     Type: string (or Expression with resultType string).
    :type service_url: object
    :param encrypted_credential: The encrypted credential used for
     authentication. Credentials are encrypted using the integration runtime
     credential manager. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type': {'key': 'type', 'type': 'str'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(AmazonS3LinkedService, self).__init__(**kwargs)
        self.access_key_id = kwargs.get('access_key_id', None)
        self.secret_access_key = kwargs.get('secret_access_key', None)
        self.service_url = kwargs.get('service_url', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.type = 'AmazonS3'
