#
# PySNMP MIB module WWW-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/WWW-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:33:08 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, ConstraintsUnion, SingleValueConstraint, ConstraintsIntersection, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "ConstraintsUnion", "SingleValueConstraint", "ConstraintsIntersection", "ValueRangeConstraint")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Bits, TimeTicks, ObjectIdentity, Counter32, Counter64, MibIdentifier, IpAddress, ModuleIdentity, Unsigned32, iso, Gauge32, Integer32, NotificationType, mib_2, MibScalar, MibTable, MibTableRow, MibTableColumn, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "TimeTicks", "ObjectIdentity", "Counter32", "Counter64", "MibIdentifier", "IpAddress", "ModuleIdentity", "Unsigned32", "iso", "Gauge32", "Integer32", "NotificationType", "mib-2", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn")
( DateAndTime, TimeInterval, TextualConvention, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "TimeInterval", "TextualConvention", "DisplayString")
( Utf8String, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "Utf8String")
wwwMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 65)).setRevisions(("1999-02-25 14:00",))
if mibBuilder.loadTexts: wwwMIB.setLastUpdated('9902251400Z')
if mibBuilder.loadTexts: wwwMIB.setOrganization('IETF Application MIB Working Group')
if mibBuilder.loadTexts: wwwMIB.setContactInfo('        Harrie Hazewinkel\n\n            Postal: Joint Research Centre of the E.C.\n                    via Fermi - Ispra 21020 (VA)\n                    Italy\n\n               Tel: +39+(0)332 786322\n               Fax: +39+(0)332 785641\n            E-mail: harrie.hazewinkel@jrc.it\n\n                    Carl W. Kalbfleisch\n\n            Postal: Verio, Inc.\n                    1950 Stemmons Freeway\n                    Suite 2006\n                    Dallas, TX 75207\n                    US\n\n               Tel: +1 214 290-8653\n               Fax: +1 214 744-0742\n            E-mail: cwk@verio.net\n\n                    Juergen Schoenwaelder\n\n            Postal: TU Braunschweig\n                    Bueltenweg 74/75\n                    38106 Braunschweig\n                    Germany\n\n               Tel: +49 531 391-3683\n               Fax: +49 531 489-5936\n            E-mail: schoenw@ibr.cs.tu-bs.de')
if mibBuilder.loadTexts: wwwMIB.setDescription("This WWW service MIB module is applicable to services\n            realized by a family of 'Document Transfer Protocols'\n            (DTP). Examples of DTPs are HTTP and FTP.")
wwwMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1))
wwwMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 2))
class WwwRequestType(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,40)

class WwwResponseType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class WwwOperStatus(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))
    namedValues = NamedValues(("down", 1), ("running", 2), ("halted", 3), ("congested", 4), ("restarting", 5),)

class WwwDocName(OctetString, TextualConvention):
    displayHint = '255a'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)

wwwService = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1, 1))
wwwServiceTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 1, 1), )
if mibBuilder.loadTexts: wwwServiceTable.setDescription('The table of the WWW services known by the SNMP agent.')
wwwServiceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"))
if mibBuilder.loadTexts: wwwServiceEntry.setDescription('Details about a particular WWW service.')
wwwServiceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: wwwServiceIndex.setDescription('An integer used to uniquely identify a WWW service. The\n            value must be the same as the corresponding value of the\n            applSrvIndex defined in the Application Management MIB\n            (APPLICATION-MIB) if the applSrvIndex object is available.\n            It might be necessary to manually configure sub-agents in\n            order to meet this requirement.')
wwwServiceDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 2), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceDescription.setDescription('Textual description of the WWW service. This shall include\n            at least the vendor and version number of the application\n            realizing the WWW service. In a minimal case, this might\n            be the Product Token (see RFC 2068) for the application.')
wwwServiceContact = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 3), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceContact.setDescription("The textual identification of the contact person for this\n            service, together with information on how to contact this\n            person. For instance, this might be a string containing an\n            email address, e.g. '<webmaster@domain.name>'.")
wwwServiceProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 4), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceProtocol.setDescription("An identification of the primary protocol in use by this\n            service. For Internet applications, the IANA maintains\n            a registry of the OIDs which correspond to well-known\n            application protocols.  If the application protocol is not\n            listed in the registry, an OID value of the form\n            {applTCPProtoID port} or {applUDPProtoID port} are used for\n            TCP-based and UDP-based protocols, respectively. In either\n            case 'port' corresponds to the primary port number being\n            used by the protocol.")
wwwServiceName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 5), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceName.setDescription('The fully qualified domain name by which this service is\n            known. This object must contain the virtual host name if\n            the service is realized for a virtual host.')
wwwServiceType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("wwwOther", 1), ("wwwServer", 2), ("wwwClient", 3), ("wwwProxy", 4), ("wwwCachingProxy", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceType.setDescription('The application type using or realizing this WWW service.')
wwwServiceStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 7), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceStartTime.setDescription("The date and time when this WWW service was last started.\n            The value SHALL be '0000000000000000'H if the last start\n            time of this WWW service is not known.")
wwwServiceOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 8), WwwOperStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceOperStatus.setDescription('Indicates the operational status of the WWW service.')
wwwServiceLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceLastChange.setDescription("The date and time when this WWW service entered its current\n            operational state. The value SHALL be '0000000000000000'H if\n            the time of the last state change is not known.")
wwwProtocolStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1, 2))
wwwSummaryTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 1), )
if mibBuilder.loadTexts: wwwSummaryTable.setDescription('The table providing overview statistics for the\n            WWW services on this system.')
wwwSummaryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"))
if mibBuilder.loadTexts: wwwSummaryEntry.setDescription('Overview statistics for an individual service.')
wwwSummaryInRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInRequests.setDescription('The number of requests successfully received.')
wwwSummaryOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutRequests.setDescription('The number of requests generated.')
wwwSummaryInResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInResponses.setDescription('The number of responses successfully received.')
wwwSummaryOutResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutResponses.setDescription('The number of responses generated.')
wwwSummaryInBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInBytes.setDescription('The number of content bytes received.')
wwwSummaryInLowBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInLowBytes.setDescription('The lowest thirty-two bits of wwwSummaryInBytes.')
wwwSummaryOutBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutBytes.setDescription('The number of content bytes transmitted.')
wwwSummaryOutLowBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutLowBytes.setDescription('The lowest thirty-two bits of wwwSummaryOutBytes.')
wwwRequestInTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 2), )
if mibBuilder.loadTexts: wwwRequestInTable.setDescription('The table providing detailed statistics for requests\n            received by WWW services on this system.')
wwwRequestInEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwRequestInIndex"))
if mibBuilder.loadTexts: wwwRequestInEntry.setDescription('Request statistics for an individual service.')
wwwRequestInIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 1), WwwRequestType())
if mibBuilder.loadTexts: wwwRequestInIndex.setDescription('The particular request type the statistics apply to.')
wwwRequestInRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestInRequests.setDescription('The number of requests of this type received by this\n            WWW service.')
wwwRequestInBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestInBytes.setDescription('The number of content bytes per request type received\n            by this WWW service.')
wwwRequestInLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestInLastTime.setDescription("The date and time when the last byte of the last complete\n            request of this type was received by this WWW service. The\n            value SHALL be '0000000000000000'H if no request of this\n            type has been received yet.")
wwwRequestOutTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 3), )
if mibBuilder.loadTexts: wwwRequestOutTable.setDescription('The table providing detailed statistics for requests\n            generated by the services on this system.')
wwwRequestOutEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwRequestOutIndex"))
if mibBuilder.loadTexts: wwwRequestOutEntry.setDescription('Request statistics for an individual service.')
wwwRequestOutIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 1), WwwRequestType())
if mibBuilder.loadTexts: wwwRequestOutIndex.setDescription('The particular request type the statistics apply to.')
wwwRequestOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestOutRequests.setDescription('The number of requests of this type generated by this\n            WWW service.')
wwwRequestOutBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestOutBytes.setDescription('The number of content bytes per requests type generated\n            by this WWW service.')
wwwRequestOutLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestOutLastTime.setDescription("The date and time when the first byte of the last request\n            of this type was send by this WWW service. The value SHALL\n            be '0000000000000000'H if no request of this type has been\n            send yet.")
wwwResponseInTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 4), )
if mibBuilder.loadTexts: wwwResponseInTable.setDescription('The table providing detailed statistics for responses\n            received by WWW services on this system.')
wwwResponseInEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwResponseInIndex"))
if mibBuilder.loadTexts: wwwResponseInEntry.setDescription('Response statistics for an individual service.')
wwwResponseInIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 1), WwwResponseType())
if mibBuilder.loadTexts: wwwResponseInIndex.setDescription('The particular response type the statistics apply to.')
wwwResponseInResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseInResponses.setDescription('The number of responses of this type received by this\n            WWW service.')
wwwResponseInBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseInBytes.setDescription('The number of content bytes per response type received\n            by this WWW service.')
wwwResponseInLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseInLastTime.setDescription("The date and time when the last byte of the last complete\n            response of this type was received by this WWW service. The\n            value SHALL be '0000000000000000'H if no response of this\n            type has been received yet.")
wwwResponseOutTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 5), )
if mibBuilder.loadTexts: wwwResponseOutTable.setDescription('The table providing detailed statistics for responses\n            generated by services on this system.')
wwwResponseOutEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwResponseOutIndex"))
if mibBuilder.loadTexts: wwwResponseOutEntry.setDescription('Response statistics for an individual service.')
wwwResponseOutIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 1), WwwResponseType())
if mibBuilder.loadTexts: wwwResponseOutIndex.setDescription('The particular response type the statistics apply to.')
wwwResponseOutResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseOutResponses.setDescription('The number of responses of this type generated by this\n            WWW service.')
wwwResponseOutBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseOutBytes.setDescription('The number of content bytes per response type generated\n            by this WWW service.')
wwwResponseOutLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseOutLastTime.setDescription("The date and time when the first byte of the last response of\n            this type was sent by this WWW service. The value SHALL be\n            '0000000000000000'H if response of this type has been send\n            yet.")
wwwDocumentStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1, 3))
wwwDocCtrlTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 1), )
if mibBuilder.loadTexts: wwwDocCtrlTable.setDescription('A table which controls how the MIB implementation\n            collects and maintains document statistics.')
wwwDocCtrlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"))
if mibBuilder.loadTexts: wwwDocCtrlEntry.setDescription('An entry used to configure the wwwDocLastNTable,\n            the wwwDocBucketTable, the wwwDocAccessTopNTable,\n            and the wwwDocBytesTopNTable.')
wwwDocCtrlLastNSize = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 1), Unsigned32().clone(25)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlLastNSize.setDescription('The maximum number of entries in the wwwDocLastNTable.')
wwwDocCtrlLastNLock = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 2), TimeTicks()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlLastNLock.setDescription('This object allows a manager to lock the wwwDocLastNTable\n            in order to retrieve the wwwDocLastNTable in a consistent\n            state. The agent is expected to take a snapshot of the\n            wwwDocLastNTable when it is locked and to continue updating\n            the real wwwDocLastNTable table so that recent information is\n            available as soon as the wwwDocLastNTable is unlocked again.\n\n            Setting this object to a value greater than 0 will lock\n            the table. The timer ticks backwards until it reaches 0.\n            The table unlocks automatically once the timer reaches 0\n            and the timer stops ticking.\n\n            A manager can increase the timer to request more time to\n            read the table. However, any attempt to decrease the timer\n            will fail with an inconsistentValue error. This rule ensures\n            that multiple managers can simultaneously lock and retrieve\n            the wwwDocLastNTable. Note that managers must cooperate in\n            using wwwDocCtrlLastNLock. In particular, a manager MUST not\n            keep the wwwDocLastNTable locked when it is not necessary to\n            finish a retrieval operation.')
wwwDocCtrlBuckets = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 3), Unsigned32().clone(4)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlBuckets.setDescription('The maximum number of buckets maintained by the agent\n            before the oldest bucket is deleted. The buckets are\n            used to populate the wwwDocAccessTopNTable and the\n            wwwDocBytesTopNTable. The time interval captured in\n            each bucket can be configured by setting the\n            wwwDocCtrlBucketTimeInterval object.')
wwwDocCtrlBucketTimeInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 4), TimeInterval().clone(90000)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlBucketTimeInterval.setDescription('The time interval after which a new bucket is created.\n            Changing this object has no effect on existing buckets.')
wwwDocCtrlTopNSize = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 5), Unsigned32().clone(25)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlTopNSize.setDescription('The maximum number of entries shown in the\n            wwwDocAccessTopNTable and the wwwDocBytesTopNTable.\n            Changing this object has no effect on existing buckets.')
wwwDocLastNTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 2), )
if mibBuilder.loadTexts: wwwDocLastNTable.setDescription('The table which logs the last N access attempts.')
wwwDocLastNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocLastNIndex"))
if mibBuilder.loadTexts: wwwDocLastNEntry.setDescription('An entry which describes a recent access attempt.')
wwwDocLastNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: wwwDocLastNIndex.setDescription('An arbitrary monotonically increasing integer number used\n            for indexing the wwwDocLastNTable. The first document\n            accessed appears in the table with this index value equal\n            to one. Each subsequent document is indexed with the next\n            sequential index value. The Nth document accessed will be\n            indexed by N. This table presents a sliding window of the\n            last wwwDocCtrlLastNSize documents accessed. Thus, entries\n            in this table will be indexed by N-wwwDocCtrlLastNSize\n            thru N if N > wwwDocCtrlLastNSize and 1 thru N if\n            N <= wwwDocCtrlLastNSize.\n\n            The wwwDocCtrlLastNLock attribute can be used to lock\n            this table to allow the manager to read its contents.')
wwwDocLastNName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 2), WwwDocName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNName.setDescription('The name of the document for which access was attempted.')
wwwDocLastNTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNTimeStamp.setDescription('The date and time of the last attempt to access this\n            document.')
wwwDocLastNRequestType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 4), WwwRequestType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNRequestType.setDescription('The protocol request type which was received by the\n            server when this document access was attempted.')
wwwDocLastNResponseType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 5), WwwResponseType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNResponseType.setDescription('The protocol response type which was sent to the client\n            as a result of this attempt to access a document. This\n            object contains the type of the primary response if\n            there were multiple responses to a single request.')
wwwDocLastNStatusMsg = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 6), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNStatusMsg.setDescription("This object contains a human readable description of the\n            reason why the wwwDocLastNResponseType was returned to the\n            client. This object defines the implementation-specific\n            reason if the value of wwwDocLastNResponseType indicates\n            an error. For example, this object can indicate that the\n            requested document could not be transferred due to a\n            timeout condition or the document could not be transferred\n            because a 'soft link' pointing to the document could not be\n            resolved.")
wwwDocLastNBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNBytes.setDescription('The number of content bytes that were returned as a\n            result of this attempt to access a document.')
wwwDocBucketTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 3), )
if mibBuilder.loadTexts: wwwDocBucketTable.setDescription('This table provides administrative summary information for\n            the buckets maintained per WWW service.')
wwwDocBucketEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocBucketIndex"))
if mibBuilder.loadTexts: wwwDocBucketEntry.setDescription('An entry which describes the parameters associated with a\n            particular bucket.')
wwwDocBucketIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: wwwDocBucketIndex.setDescription('An arbitrary monotonically increasing integer number\n            used for indexing the wwwDocBucketTable. The index number\n            wraps to 1 whenever the maximum value is reached.')
wwwDocBucketTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketTimeStamp.setDescription('The date and time when the bucket was made available.')
wwwDocBucketAccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketAccesses.setDescription('The total number of access attempts for any document\n            provided by this WWW service during the time interval\n            over which this bucket was created.')
wwwDocBucketDocuments = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketDocuments.setDescription('The total number of different documents for which access\n            was attempted this this WWW service during the time interval\n            over which this bucket was created.')
wwwDocBucketBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketBytes.setDescription('The total number of content bytes which were transferred\n            from this WWW service during the time interval over which\n            this bucket was created.')
wwwDocAccessTopNTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 4), )
if mibBuilder.loadTexts: wwwDocAccessTopNTable.setDescription('The table of the most frequently accessed documents in a\n            given bucket. This table is sorted by the column\n            wwwDocAccessTopNAccesses. Entries having the same number\n            of accesses are secondarily sorted by wwwDocAccessTopNBytes.\n            Entries with the same number of accesses and the same\n            number of bytes will have an arbitrary order.')
wwwDocAccessTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocBucketIndex"), (0, "WWW-MIB", "wwwDocAccessTopNIndex"))
if mibBuilder.loadTexts: wwwDocAccessTopNEntry.setDescription('An entry in the top N table sorted by document accesses.')
wwwDocAccessTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: wwwDocAccessTopNIndex.setDescription('An arbitrary monotonically increasing integer number\n            used for indexing the wwwDocAccessTopNTable. The index is\n            inversely correlated to the sorting order of the table. The\n            document with the highest access count will get the index\n            value 1.')
wwwDocAccessTopNName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 2), WwwDocName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNName.setDescription('The name of the document for which access was attempted.')
wwwDocAccessTopNAccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNAccesses.setDescription('The total number of access attempts for this document.')
wwwDocAccessTopNBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNBytes.setDescription('The total number of content bytes that were transmitted\n            as a result of attempts to access this document.')
wwwDocAccessTopNLastResponseType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 5), WwwResponseType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNLastResponseType.setDescription('The protocol response type which was sent to the client\n            as a result of the last attempt to access this document.\n            This object contains the type of the primary response if\n            there were multiple responses to a single request.')
wwwDocBytesTopNTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 5), )
if mibBuilder.loadTexts: wwwDocBytesTopNTable.setDescription('The table of the documents which caused most network\n            traffic in a given bucket. This table is sorted by the\n            column wwwDocBytesTopNBytes. Entries having the same number\n            bytes are secondarily sorted by wwwDocBytesTopNAccesses.\n            Entries with the same number of accesses and the same\n            number of bytes will have an arbitrary order.')
wwwDocBytesTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1), ).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocBucketIndex"), (0, "WWW-MIB", "wwwDocBytesTopNIndex"))
if mibBuilder.loadTexts: wwwDocBytesTopNEntry.setDescription('An entry in the top N table sorted by network traffic.')
wwwDocBytesTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: wwwDocBytesTopNIndex.setDescription('An arbitrary monotonically increasing integer number\n            used for indexing the wwwDocBytesTopNTable. The index is\n            inversely correlated to the sorting order of the table. The\n            document with the highest byte count will get the index\n            value 1.')
wwwDocBytesTopNName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 2), WwwDocName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNName.setDescription('The name of the document for which access was attempted.')
wwwDocBytesTopNAccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNAccesses.setDescription('The total number of access attempts for this document.')
wwwDocBytesTopNBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNBytes.setDescription('The total number of content bytes that were transmitted\n            as a result of attempts to access this document.')
wwwDocBytesTopNLastResponseType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 5), WwwResponseType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNLastResponseType.setDescription('The protocol response type which was sent to the client\n            as a result of the last attempt to access this document.\n            This object contains the type of the primary response if\n            there were multiple responses to a single request.')
wwwMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 2, 1))
wwwMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 2, 2))
wwwMinimalCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 65, 2, 1, 1)).setObjects(*(("WWW-MIB", "wwwServiceGroup"), ("WWW-MIB", "wwwSummaryGroup"),))
if mibBuilder.loadTexts: wwwMinimalCompliance.setDescription('The compliance statement for SNMP agents which implement\n            the minimal subset of the WWW-MIB. Implementors might\n            choose this subset for high-performance server where\n            full compliance might be to expensive.')
wwwFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 65, 2, 1, 2)).setObjects(*(("WWW-MIB", "wwwServiceGroup"), ("WWW-MIB", "wwwSummaryGroup"), ("WWW-MIB", "wwwRequestInGroup"), ("WWW-MIB", "wwwResponseOutGroup"), ("WWW-MIB", "wwwRequestOutGroup"), ("WWW-MIB", "wwwResponseInGroup"), ("WWW-MIB", "wwwDocumentGroup"),))
if mibBuilder.loadTexts: wwwFullCompliance.setDescription('The compliance statement for SNMP agents which implement\n            the full WWW-MIB.')
wwwServiceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 1)).setObjects(*(("WWW-MIB", "wwwServiceDescription"), ("WWW-MIB", "wwwServiceContact"), ("WWW-MIB", "wwwServiceProtocol"), ("WWW-MIB", "wwwServiceName"), ("WWW-MIB", "wwwServiceType"), ("WWW-MIB", "wwwServiceStartTime"), ("WWW-MIB", "wwwServiceOperStatus"), ("WWW-MIB", "wwwServiceLastChange"),))
if mibBuilder.loadTexts: wwwServiceGroup.setDescription('A collection of objects providing information about\n            the WWW services known by the SNMP agent.')
wwwSummaryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 2)).setObjects(*(("WWW-MIB", "wwwSummaryInRequests"), ("WWW-MIB", "wwwSummaryOutRequests"), ("WWW-MIB", "wwwSummaryInResponses"), ("WWW-MIB", "wwwSummaryOutResponses"), ("WWW-MIB", "wwwSummaryInBytes"), ("WWW-MIB", "wwwSummaryInLowBytes"), ("WWW-MIB", "wwwSummaryOutBytes"), ("WWW-MIB", "wwwSummaryOutLowBytes"),))
if mibBuilder.loadTexts: wwwSummaryGroup.setDescription('A collection of objects providing summary statistics\n            about requests and responses generated and received\n            by a WWW service.')
wwwRequestInGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 3)).setObjects(*(("WWW-MIB", "wwwRequestInRequests"), ("WWW-MIB", "wwwRequestInBytes"), ("WWW-MIB", "wwwRequestInLastTime"),))
if mibBuilder.loadTexts: wwwRequestInGroup.setDescription('A collection of objects providing detailed statistics\n            about requests received by a WWW service.')
wwwRequestOutGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 4)).setObjects(*(("WWW-MIB", "wwwRequestOutRequests"), ("WWW-MIB", "wwwRequestOutBytes"), ("WWW-MIB", "wwwRequestOutLastTime"),))
if mibBuilder.loadTexts: wwwRequestOutGroup.setDescription('A collection of objects providing detailed statistics\n            about requests generated by a WWW service.')
wwwResponseInGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 5)).setObjects(*(("WWW-MIB", "wwwResponseInResponses"), ("WWW-MIB", "wwwResponseInBytes"), ("WWW-MIB", "wwwResponseInLastTime"),))
if mibBuilder.loadTexts: wwwResponseInGroup.setDescription('A collection of objects providing detailed statistics\n            about responses received by a WWW service.')
wwwResponseOutGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 6)).setObjects(*(("WWW-MIB", "wwwResponseOutResponses"), ("WWW-MIB", "wwwResponseOutBytes"), ("WWW-MIB", "wwwResponseOutLastTime"),))
if mibBuilder.loadTexts: wwwResponseOutGroup.setDescription('A collection of objects providing detailed statistics\n            about responses generated by a WWW service.')
wwwDocumentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 7)).setObjects(*(("WWW-MIB", "wwwDocCtrlLastNSize"), ("WWW-MIB", "wwwDocCtrlLastNLock"), ("WWW-MIB", "wwwDocCtrlBuckets"), ("WWW-MIB", "wwwDocCtrlBucketTimeInterval"), ("WWW-MIB", "wwwDocCtrlTopNSize"), ("WWW-MIB", "wwwDocLastNName"), ("WWW-MIB", "wwwDocLastNTimeStamp"), ("WWW-MIB", "wwwDocLastNRequestType"), ("WWW-MIB", "wwwDocLastNResponseType"), ("WWW-MIB", "wwwDocLastNStatusMsg"), ("WWW-MIB", "wwwDocLastNBytes"), ("WWW-MIB", "wwwDocBucketTimeStamp"), ("WWW-MIB", "wwwDocBucketAccesses"), ("WWW-MIB", "wwwDocBucketDocuments"), ("WWW-MIB", "wwwDocBucketBytes"), ("WWW-MIB", "wwwDocAccessTopNName"), ("WWW-MIB", "wwwDocAccessTopNAccesses"), ("WWW-MIB", "wwwDocAccessTopNBytes"), ("WWW-MIB", "wwwDocAccessTopNLastResponseType"), ("WWW-MIB", "wwwDocBytesTopNName"), ("WWW-MIB", "wwwDocBytesTopNAccesses"), ("WWW-MIB", "wwwDocBytesTopNBytes"), ("WWW-MIB", "wwwDocBytesTopNLastResponseType"),))
if mibBuilder.loadTexts: wwwDocumentGroup.setDescription('A collection of objects providing information about\n            accesses to documents.')
mibBuilder.exportSymbols("WWW-MIB", wwwDocBytesTopNName=wwwDocBytesTopNName, wwwResponseOutEntry=wwwResponseOutEntry, wwwDocLastNTimeStamp=wwwDocLastNTimeStamp, wwwDocLastNEntry=wwwDocLastNEntry, wwwDocLastNName=wwwDocLastNName, wwwMIBCompliances=wwwMIBCompliances, wwwDocCtrlLastNLock=wwwDocCtrlLastNLock, wwwSummaryOutResponses=wwwSummaryOutResponses, wwwDocAccessTopNAccesses=wwwDocAccessTopNAccesses, wwwRequestInBytes=wwwRequestInBytes, wwwRequestOutLastTime=wwwRequestOutLastTime, wwwService=wwwService, wwwResponseOutBytes=wwwResponseOutBytes, wwwDocLastNIndex=wwwDocLastNIndex, wwwMIB=wwwMIB, wwwMinimalCompliance=wwwMinimalCompliance, wwwResponseInIndex=wwwResponseInIndex, wwwRequestInEntry=wwwRequestInEntry, wwwMIBConformance=wwwMIBConformance, wwwRequestInTable=wwwRequestInTable, wwwServiceName=wwwServiceName, wwwSummaryInBytes=wwwSummaryInBytes, wwwDocBucketAccesses=wwwDocBucketAccesses, wwwDocAccessTopNIndex=wwwDocAccessTopNIndex, wwwDocLastNRequestType=wwwDocLastNRequestType, wwwServiceProtocol=wwwServiceProtocol, wwwDocumentStatistics=wwwDocumentStatistics, wwwDocBucketBytes=wwwDocBucketBytes, wwwRequestInGroup=wwwRequestInGroup, wwwSummaryInResponses=wwwSummaryInResponses, wwwResponseOutGroup=wwwResponseOutGroup, WwwResponseType=WwwResponseType, wwwSummaryOutBytes=wwwSummaryOutBytes, wwwDocCtrlBuckets=wwwDocCtrlBuckets, wwwRequestOutRequests=wwwRequestOutRequests, wwwDocCtrlTable=wwwDocCtrlTable, wwwRequestOutGroup=wwwRequestOutGroup, wwwRequestInRequests=wwwRequestInRequests, wwwRequestInIndex=wwwRequestInIndex, wwwFullCompliance=wwwFullCompliance, wwwRequestInLastTime=wwwRequestInLastTime, wwwServiceContact=wwwServiceContact, wwwServiceGroup=wwwServiceGroup, wwwResponseInTable=wwwResponseInTable, wwwSummaryOutLowBytes=wwwSummaryOutLowBytes, wwwDocAccessTopNLastResponseType=wwwDocAccessTopNLastResponseType, wwwRequestOutEntry=wwwRequestOutEntry, wwwSummaryEntry=wwwSummaryEntry, wwwDocLastNTable=wwwDocLastNTable, wwwRequestOutIndex=wwwRequestOutIndex, wwwDocCtrlEntry=wwwDocCtrlEntry, wwwDocAccessTopNBytes=wwwDocAccessTopNBytes, wwwDocLastNStatusMsg=wwwDocLastNStatusMsg, wwwDocBucketDocuments=wwwDocBucketDocuments, wwwResponseOutTable=wwwResponseOutTable, wwwDocBytesTopNIndex=wwwDocBytesTopNIndex, wwwResponseInLastTime=wwwResponseInLastTime, WwwOperStatus=WwwOperStatus, wwwServiceType=wwwServiceType, wwwDocBytesTopNAccesses=wwwDocBytesTopNAccesses, wwwSummaryTable=wwwSummaryTable, wwwDocBucketTable=wwwDocBucketTable, wwwMIBObjects=wwwMIBObjects, wwwDocBucketIndex=wwwDocBucketIndex, wwwSummaryOutRequests=wwwSummaryOutRequests, wwwDocLastNResponseType=wwwDocLastNResponseType, wwwResponseInBytes=wwwResponseInBytes, wwwServiceIndex=wwwServiceIndex, wwwServiceEntry=wwwServiceEntry, wwwMIBGroups=wwwMIBGroups, wwwDocAccessTopNName=wwwDocAccessTopNName, wwwSummaryGroup=wwwSummaryGroup, wwwProtocolStatistics=wwwProtocolStatistics, wwwDocCtrlBucketTimeInterval=wwwDocCtrlBucketTimeInterval, wwwSummaryInLowBytes=wwwSummaryInLowBytes, wwwDocAccessTopNEntry=wwwDocAccessTopNEntry, wwwServiceTable=wwwServiceTable, PYSNMP_MODULE_ID=wwwMIB, wwwRequestOutBytes=wwwRequestOutBytes, wwwDocBytesTopNEntry=wwwDocBytesTopNEntry, wwwDocLastNBytes=wwwDocLastNBytes, wwwServiceDescription=wwwServiceDescription, WwwRequestType=WwwRequestType, wwwDocCtrlLastNSize=wwwDocCtrlLastNSize, wwwSummaryInRequests=wwwSummaryInRequests, wwwServiceLastChange=wwwServiceLastChange, wwwDocCtrlTopNSize=wwwDocCtrlTopNSize, wwwResponseOutResponses=wwwResponseOutResponses, wwwDocBucketEntry=wwwDocBucketEntry, wwwDocBytesTopNBytes=wwwDocBytesTopNBytes, wwwServiceStartTime=wwwServiceStartTime, wwwDocAccessTopNTable=wwwDocAccessTopNTable, wwwResponseInGroup=wwwResponseInGroup, wwwDocBytesTopNTable=wwwDocBytesTopNTable, wwwResponseInResponses=wwwResponseInResponses, wwwServiceOperStatus=wwwServiceOperStatus, wwwDocBucketTimeStamp=wwwDocBucketTimeStamp, wwwDocBytesTopNLastResponseType=wwwDocBytesTopNLastResponseType, wwwRequestOutTable=wwwRequestOutTable, WwwDocName=WwwDocName, wwwResponseOutIndex=wwwResponseOutIndex, wwwResponseOutLastTime=wwwResponseOutLastTime, wwwResponseInEntry=wwwResponseInEntry, wwwDocumentGroup=wwwDocumentGroup)
